<?php
// admin_usuarios.php
require_once 'config.php';
verificarRole(['admin']);

$sucesso = '';
$erro = '';

// Aprovar usuário
if (isset($_GET['acao']) && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $acao = $_GET['acao'];

    if ($acao === 'aprovar') {
        $stmt = $pdo->prepare("UPDATE users SET status = 'aprovado' WHERE id = ?");
        if ($stmt->execute([$id])) {
            $sucesso = 'Usuário aprovado com sucesso!';
        }
    } elseif ($acao === 'bloquear') {
        $stmt = $pdo->prepare("UPDATE users SET status = 'bloqueado' WHERE id = ?");
        if ($stmt->execute([$id])) {
            $sucesso = 'Usuário bloqueado!';
        }
    } elseif ($acao === 'deletar') {
        $stmt = $pdo->prepare("DELETE FROM users WHERE id = ? AND role != 'admin'");
        if ($stmt->execute([$id])) {
            $sucesso = 'Usuário deletado!';
        }
    }
}

// Atualizar role
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['atualizar_role'])) {
    $user_id = intval($_POST['user_id']);
    $nova_role = $_POST['role'];

    try {
        // Verificar se o role é válido
        $roles_validos = ['user', 'gerente', 'produtor'];
        if (!in_array($nova_role, $roles_validos)) {
            $erro = 'Role inválido: ' . htmlspecialchars($nova_role);
        } else {
            $stmt = $pdo->prepare("UPDATE users SET role = ? WHERE id = ?");
            if ($stmt->execute([$nova_role, $user_id])) {
                $sucesso = 'Permissões atualizadas!';
            } else {
                $erro = 'Erro ao executar UPDATE';
            }
        }
    } catch (PDOException $e) {
        $erro = 'Erro SQL: ' . $e->getMessage();
        error_log('Erro ao atualizar role: ' . $e->getMessage());
    }
}

// Associar produtor a evento
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['associar_produtor'])) {
    $user_id = intval($_POST['user_id']);
    $evento_id = intval($_POST['evento_id']);

    // Verificar se já existe associação
    $stmt = $pdo->prepare("SELECT id FROM produtor_eventos WHERE user_id = ? AND evento_id = ?");
    $stmt->execute([$user_id, $evento_id]);

    if (!$stmt->fetch()) {
        // Gerar link exclusivo
        $link_exclusivo = bin2hex(random_bytes(16)); // 32 caracteres

        $stmt = $pdo->prepare("INSERT INTO produtor_eventos (user_id, evento_id, link_exclusivo) VALUES (?, ?, ?)");
        if ($stmt->execute([$user_id, $evento_id, $link_exclusivo])) {
            $sucesso = 'Produtor associado ao evento com sucesso!';
        }
    } else {
        $erro = 'Produtor já está associado a este evento!';
    }
}

// Remover associação produtor-evento
if (isset($_GET['remover_associacao'])) {
    $associacao_id = intval($_GET['remover_associacao']);
    $stmt = $pdo->prepare("DELETE FROM produtor_eventos WHERE id = ?");
    if ($stmt->execute([$associacao_id])) {
        $sucesso = 'Associação removida!';
    }
}

// Buscar usuários pendentes
$stmt = $pdo->query("
    SELECT u.*,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = u.id) as total_convidados,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = u.id AND c.checkin = 1) as total_checkins
    FROM users u
    WHERE status = 'pendente' AND role != 'admin'
    ORDER BY created_at DESC
");
$usuarios_pendentes = $stmt->fetchAll();

// Buscar todos os usuários
$stmt = $pdo->query("
    SELECT u.*,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = u.id) as total_convidados,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = u.id AND c.checkin = 1) as total_checkins,
    (SELECT COUNT(*) FROM produtor_eventos pe WHERE pe.user_id = u.id) as total_eventos
    FROM users u
    WHERE role != 'admin'
    ORDER BY created_at DESC
");
$usuarios = $stmt->fetchAll();

// Variáveis necessárias para a navbar
$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="pt-BR" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Usuários - Admin</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">
    <link rel="stylesheet" href="assets/css/sidebar.css">

    <style>
        .user-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 20px;
        }

        .user-card {
            background: var(--bg-card);
            border: 2px solid var(--border-color);
            border-radius: 15px;
            padding: 20px;
            transition: all 0.3s;
        }

        .user-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 20px rgba(255, 215, 0, 0.2);
            border-color: var(--border-gold);
        }

        .user-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 15px;
        }

        .user-name {
            font-size: 18px;
            font-weight: 700;
            color: var(--color-gold);
            margin-bottom: 8px;
        }

        .user-info {
            font-size: 13px;
            color: var(--text-secondary);
            margin-bottom: 8px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .user-stats {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            margin: 15px 0;
            padding: 15px 0;
            border-top: 1px solid var(--border-color);
            border-bottom: 1px solid var(--border-color);
        }

        .stat-item {
            text-align: center;
        }

        .stat-value {
            font-size: 20px;
            font-weight: 700;
            color: var(--color-gold);
        }

        .stat-label {
            font-size: 10px;
            color: var(--text-secondary);
            text-transform: uppercase;
        }

        .user-actions {
            display: flex;
            gap: 8px;
            margin-top: 15px;
            flex-wrap: wrap;
        }

        .role-form {
            margin-top: 10px;
            display: flex;
            gap: 10px;
            align-items: center;
        }

        .role-form select {
            flex: 1;
        }

        .eventos-section {
            margin-top: 15px;
            padding-top: 15px;
            border-top: 2px solid var(--border-color);
        }

        .eventos-title {
            font-weight: 700;
            margin-bottom: 10px;
            color: var(--color-gold);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .evento-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 8px;
            background: var(--bg-secondary);
            border-radius: 5px;
            margin-bottom: 5px;
            font-size: 12px;
        }

        .evento-info {
            flex: 1;
        }

        .evento-info strong {
            color: var(--text-primary);
        }

        .evento-info small {
            color: var(--text-secondary);
        }

        @media (max-width: 768px) {
            .user-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>

    <?php include 'assets/sidebar.php'; ?>

    <div class="container">

        <!-- Alerts -->
        <?php if ($sucesso): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?= htmlspecialchars($sucesso) ?>
            </div>
        <?php endif; ?>

        <?php if ($erro): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i>
                <?= htmlspecialchars($erro) ?>
            </div>
        <?php endif; ?>

        <!-- Header -->
        <div class="welcome-section">
            <h1 class="welcome-title">
                <i class="fas fa-users-cog"></i>
                Gerenciar Usuários
            </h1>
            <p class="welcome-subtitle">
                Gerencie aprovações, permissões e associações de usuários e produtores
            </p>
        </div>

        <!-- Usuários Pendentes -->
        <?php if (count($usuarios_pendentes) > 0): ?>
            <div class="section-title">
                <i class="fas fa-clock"></i>
                Aguardando Aprovação (<?= count($usuarios_pendentes) ?>)
            </div>

            <div class="user-grid">
                <?php foreach ($usuarios_pendentes as $user): ?>
                    <div class="user-card">
                        <div class="user-header">
                            <div>
                                <div class="user-name"><?= htmlspecialchars($user['nome']) ?></div>
                                <span class="badge badge-warning">Pendente</span>
                            </div>
                        </div>

                        <div class="user-info">
                            <i class="fas fa-envelope"></i>
                            <?= htmlspecialchars($user['email']) ?>
                        </div>
                        <div class="user-info">
                            <i class="fas fa-phone"></i>
                            <?= htmlspecialchars($user['telefone']) ?>
                        </div>
                        <?php if ($user['instagram']): ?>
                            <div class="user-info">
                                <i class="fab fa-instagram"></i>
                                <?= htmlspecialchars($user['instagram']) ?>
                            </div>
                        <?php endif; ?>
                        <div class="user-info">
                            <i class="fas fa-map-marker-alt"></i>
                            <?= htmlspecialchars($user['cidade']) ?> - <?= htmlspecialchars($user['bairro']) ?>
                        </div>
                        <div class="user-info">
                            <i class="fas fa-birthday-cake"></i>
                            <?= $user['idade'] ?> anos
                        </div>
                        <div class="user-info">
                            <i class="fas fa-calendar"></i>
                            Cadastro: <?= formatarData($user['created_at']) ?>
                        </div>

                        <div class="user-actions">
                            <a href="?acao=aprovar&id=<?= $user['id'] ?>" class="btn btn-success">
                                <i class="fas fa-check"></i> Aprovar
                            </a>
                            <a href="?acao=bloquear&id=<?= $user['id'] ?>" class="btn btn-danger" onclick="return confirm('Tem certeza?')">
                                <i class="fas fa-ban"></i> Rejeitar
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <!-- Todos os Usuários -->
        <div class="section-title" style="margin-top: 40px;">
            <i class="fas fa-users"></i>
            Todos os Usuários (<?= count($usuarios) ?>)
        </div>

        <?php if (count($usuarios) > 0): ?>
            <div class="user-grid">
                <?php foreach ($usuarios as $user): ?>
                    <div class="user-card">
                        <div class="user-header">
                            <div>
                                <div class="user-name"><?= htmlspecialchars($user['nome']) ?></div>
                                <?php if ($user['status'] === 'aprovado'): ?>
                                    <span class="badge badge-success">Aprovado</span>
                                <?php elseif ($user['status'] === 'bloqueado'): ?>
                                    <span class="badge badge-danger">Bloqueado</span>
                                <?php else: ?>
                                    <span class="badge badge-warning">Pendente</span>
                                <?php endif; ?>

                                <?php if ($user['role'] === 'gerente'): ?>
                                    <span class="badge badge-info">Gerente</span>
                                <?php elseif ($user['role'] === 'produtor'): ?>
                                    <span class="badge" style="background: #9C27B0; color: white;">Produtor</span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="user-info">
                            <i class="fas fa-envelope"></i>
                            <?= htmlspecialchars($user['email']) ?>
                        </div>
                        <div class="user-info">
                            <i class="fas fa-phone"></i>
                            <?= htmlspecialchars($user['telefone']) ?>
                        </div>
                        <div class="user-info">
                            <i class="fas fa-star"></i>
                            Pontuação: <?= $user['pontuacao'] ?> pontos
                        </div>

                        <div class="user-stats">
                            <div class="stat-item">
                                <div class="stat-value"><?= $user['total_eventos'] ?></div>
                                <div class="stat-label">Eventos</div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-value"><?= $user['total_convidados'] ?></div>
                                <div class="stat-label">Convidados</div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-value"><?= $user['total_checkins'] ?></div>
                                <div class="stat-label">Check-ins</div>
                            </div>
                        </div>

                        <form method="POST" class="role-form">
                            <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                            <select name="role" required>
                                <option value="user" <?= $user['role'] === 'user' ? 'selected' : '' ?>>Promoter</option>
                                <option value="gerente" <?= $user['role'] === 'gerente' ? 'selected' : '' ?>>Gerente</option>
                                <option value="produtor" <?= $user['role'] === 'produtor' ? 'selected' : '' ?>>Produtor</option>
                            </select>
                            <button type="submit" name="atualizar_role" class="btn btn-primary">
                                <i class="fas fa-save"></i> Salvar
                            </button>
                        </form>

                        <?php if ($user['role'] === 'produtor'): ?>
                            <?php
                            // Buscar eventos associados ao produtor
                            $stmt_eventos = $pdo->prepare("
                                SELECT pe.*, e.nome as evento_nome, e.data, e.status
                                FROM produtor_eventos pe
                                JOIN eventos e ON pe.evento_id = e.id
                                WHERE pe.user_id = ?
                                ORDER BY e.data DESC
                            ");
                            $stmt_eventos->execute([$user['id']]);
                            $eventos_associados = $stmt_eventos->fetchAll();

                            // Buscar eventos disponíveis para associar
                            $stmt_disponiveis = $pdo->prepare("
                                SELECT e.id, e.nome, e.data, e.status
                                FROM eventos e
                                WHERE e.id NOT IN (
                                    SELECT evento_id FROM produtor_eventos WHERE user_id = ?
                                )
                                AND e.status = 'ativo'
                                ORDER BY e.data DESC
                            ");
                            $stmt_disponiveis->execute([$user['id']]);
                            $eventos_disponiveis = $stmt_disponiveis->fetchAll();
                            ?>

                            <div class="eventos-section">
                                <div class="eventos-title">
                                    <i class="fas fa-calendar-check"></i>
                                    Eventos Associados (<?= count($eventos_associados) ?>)
                                </div>

                                <?php if (count($eventos_associados) > 0): ?>
                                    <div style="margin-bottom: 10px;">
                                        <?php foreach ($eventos_associados as $evt): ?>
                                            <div class="evento-item">
                                                <div class="evento-info">
                                                    <strong><?= htmlspecialchars($evt['evento_nome']) ?></strong>
                                                    <br><small><?= date('d/m/Y', strtotime($evt['data'])) ?></small>
                                                </div>
                                                <a href="?remover_associacao=<?= $evt['id'] ?>"
                                                   class="btn btn-danger btn-sm"
                                                   onclick="return confirm('Remover associação com este evento?')">
                                                    <i class="fas fa-times"></i>
                                                </a>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                <?php else: ?>
                                    <div style="font-size: 12px; color: var(--text-secondary); margin-bottom: 10px;">
                                        Nenhum evento associado ainda
                                    </div>
                                <?php endif; ?>

                                <?php if (count($eventos_disponiveis) > 0): ?>
                                    <form method="POST" style="display: flex; gap: 5px;">
                                        <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
                                        <select name="evento_id" required style="flex: 1; font-size: 11px; padding: 6px;">
                                            <option value="">Selecione um evento...</option>
                                            <?php foreach ($eventos_disponiveis as $evt): ?>
                                                <option value="<?= $evt['id'] ?>">
                                                    <?= htmlspecialchars($evt['nome']) ?> - <?= date('d/m/Y', strtotime($evt['data'])) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <button type="submit" name="associar_produtor" class="btn btn-success btn-sm">
                                            <i class="fas fa-plus"></i> Associar
                                        </button>
                                    </form>
                                <?php else: ?>
                                    <div style="font-size: 11px; color: var(--text-secondary);">
                                        Todos os eventos ativos já estão associados
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>

                        <div class="user-actions">
                            <?php if ($user['status'] === 'aprovado'): ?>
                                <a href="?acao=bloquear&id=<?= $user['id'] ?>" class="btn btn-danger btn-sm">
                                    <i class="fas fa-lock"></i> Bloquear
                                </a>
                            <?php else: ?>
                                <a href="?acao=aprovar&id=<?= $user['id'] ?>" class="btn btn-success btn-sm">
                                    <i class="fas fa-check"></i> Aprovar
                                </a>
                            <?php endif; ?>

                            <a href="admin_perfil_promoter.php?id=<?= $user['id'] ?>" class="btn btn-primary btn-sm">
                                <i class="fas fa-user"></i> Ver Perfil
                            </a>

                            <a href="?acao=deletar&id=<?= $user['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Deletar usuário e todos os dados?')">
                                <i class="fas fa-trash"></i> Deletar
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="empty-state">
                <i class="fas fa-users"></i>
                <h3>Nenhum usuário cadastrado ainda</h3>
            </div>
        <?php endif; ?>
    </div>

    </div><!-- /.main-content -->
    <script src="assets/js/sidebar.js"></script>
</body>
</html>
