<?php
// config.php - VERSAO FINAL CORRIGIDA
// ATENCAO: Este arquivo DEVE ser salvo como UTF-8 SEM BOM

// SOLUCAO: Iniciar output buffering ANTES de tudo
if (ob_get_level() == 0) {
    ob_start();
}

// Iniciar sessao com tratamento de erro
if (session_status() === PHP_SESSION_NONE) {
    @session_start();
}

// Configuracoes do Banco de Dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'luminainkcom_promoters_system');
define('DB_USER', 'luminainkcom_promoter_user');
define('DB_PASS', 'gHy;~@;]n}]BIeRO');

// Timezone
date_default_timezone_set('America/Sao_Paulo');

// Conexao com Banco de Dados
try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch(PDOException $e) {
    error_log("Erro na conexao: " . $e->getMessage());
    die("Erro na conexao com o banco de dados. Verifique os logs.");
}

// ====================================
// CONFIGURACOES DE EMAIL - ENVIO NATIVO (PHP mail())
// ====================================
// NOTA: Esta versao usa envio nativo do PHP atraves da funcao mail()
// Em versoes futuras, sera implementado SMTP para maior controle
// As configuracoes sao carregadas do banco de dados (tabela configuracoes)

try {
    $stmt_email_config = $pdo->query("SELECT email_remetente, email_nome_remetente FROM configuracoes WHERE id = 1");
    $email_config = $stmt_email_config->fetch();

    if ($email_config) {
        define('EMAIL_REMETENTE', $email_config['email_remetente']);
        define('EMAIL_NOME_REMETENTE', $email_config['email_nome_remetente']);
    } else {
        // Valores padrao caso nao exista configuracao
        define('EMAIL_REMETENTE', 'noreply@seudominio.com.br');
        define('EMAIL_NOME_REMETENTE', 'Sistema Promotaal');
    }
} catch(PDOException $e) {
    // Em caso de erro, usar valores padrao
    error_log("Erro ao carregar config de email: " . $e->getMessage());
    define('EMAIL_REMETENTE', 'noreply@seudominio.com.br');
    define('EMAIL_NOME_REMETENTE', 'Sistema Promotaal');
}

// ====================================
// INCLUIR FUNCOES DE NOTIFICACOES
// ====================================
require_once __DIR__ . '/includes/functions_notificacoes.php';

// ====================================
// FUNCOES AUXILIARES
// ====================================

function verificarLogin() {
    if (!isset($_SESSION['user_id'])) {
        header('Location: login.php');
        exit;
    }
}

function verificarRole($roles_permitidas) {
    verificarLogin();
    if (!in_array($_SESSION['role'], $roles_permitidas)) {
        header('Location: dashboard.php');
        exit;
    }
}

function gerarToken($tamanho = 32) {
    return bin2hex(random_bytes($tamanho));
}

function formatarMoeda($valor) {
    if ($valor === null || $valor === '') {
        return 'R$ 0,00';
    }
    return 'R$ ' . number_format(floatval($valor), 2, ',', '.');
}

function formatarData($data) {
    if (empty($data)) {
        return '-';
    }
    
    try {
        $timestamp = strtotime($data);
        if ($timestamp === false) {
            return '-';
        }
        return date('d/m/Y', $timestamp);
    } catch (Exception $e) {
        return '-';
    }
}

function formatarDataHora($data) {
    if (empty($data)) {
        return '-';
    }
    
    try {
        $timestamp = strtotime($data);
        if ($timestamp === false) {
            return '-';
        }
        return date('d/m/Y H:i', $timestamp);
    } catch (Exception $e) {
        return '-';
    }
}

function sanitizar($string) {
    if (is_array($string)) {
        return array_map('sanitizar', $string);
    }
    return htmlspecialchars(trim($string), ENT_QUOTES, 'UTF-8');
}

function validarEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}

function validarTelefone($telefone) {
    $telefone = preg_replace('/[^0-9]/', '', $telefone);
    return strlen($telefone) >= 10 && strlen($telefone) <= 11;
}

function gerarQRCode() {
    return strtoupper(bin2hex(random_bytes(8)));
}

function logErro($mensagem, $arquivo = '', $linha = '') {
    $log = date('[Y-m-d H:i:s] ');
    if ($arquivo) {
        $log .= "[$arquivo";
        if ($linha) {
            $log .= ":$linha";
        }
        $log .= "] ";
    }
    $log .= $mensagem . "\n";
    
    $log_dir = __DIR__ . '/logs';
    if (!is_dir($log_dir)) {
        @mkdir($log_dir, 0755, true);
    }
    
    @error_log($log, 3, $log_dir . '/erros.log');
}
?>