<?php
// convite.php - VERSÃO CORRIGIDA - SEM DEPRECATED + DATA NASCIMENTO CORRETA
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!file_exists('config.php')) {
    die('ERRO: Arquivo config.php não encontrado');
}

if (!file_exists('functions.php')) {
    die('ERRO: Arquivo functions.php não encontrado');
}

require_once 'config.php';
require_once 'functions.php';

$link = $_GET['link'] ?? '';
$sucesso = false;
$erro = '';
$qr_code_gerado = '';
$email_convidado = '';
$nome_convidado = '';

// Validar se link foi fornecido
if (empty($link)) {
    die('
    <!DOCTYPE html>
    <html lang="pt-BR">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Link Necessário</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                background: linear-gradient(135deg, #000 0%, #1a1a1a 100%);
                color: white;
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                text-align: center;
                padding: 20px;
            }
            h1 { font-size: 48px; margin-bottom: 20px; }
        </style>
    </head>
    <body>
        <div>
            <h1><i class="fas fa-exclamation-triangle" style="color: #FFA500;"></i></h1>
            <h2>Link de Convite Necessário</h2>
            <p>Acesse este link através do convite enviado pelo promoter.</p>
        </div>
        </div><!-- /.main-content -->
    <script src="assets/js/sidebar.js"></script>
</body>
    </html>
    ');
}

// Buscar informações do link (suporta promoters e produtores)
try {
    $stmt = $pdo->prepare("
        SELECT pe.*, e.nome as evento_nome, e.data, e.hora, e.imagem, e.informacoes_importantes,
               u.nome as promoter_nome, u.role as user_role, e.id as evento_id
        FROM produtor_eventos pe
        INNER JOIN eventos e ON pe.evento_id = e.id
        INNER JOIN users u ON pe.user_id = u.id
        WHERE pe.link_exclusivo = ? AND e.status = 'ativo'
    ");
    $stmt->execute([$link]);
    $convite = $stmt->fetch();
} catch (Exception $e) {
    die('ERRO DE BANCO: ' . $e->getMessage());
}

if (!$convite) {
    die('
    <!DOCTYPE html>
    <html lang="pt-BR">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Link Inválido</title>
        <style>
            body {
                font-family: Arial, sans-serif;
                background: linear-gradient(135deg, #000 0%, #1a1a1a 100%);
                color: white;
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                text-align: center;
                padding: 20px;
            }
            h1 { font-size: 48px; margin-bottom: 20px; }
        </style>
    </head>
    <body>
        <div>
            <h1><i class="fas fa-times-circle" style="color: #ff4444;"></i></h1>
            <h2>Link Inválido ou Evento Encerrado</h2>
            <p>Entre em contato com quem compartilhou este link.</p>
        </div>
        </div><!-- /.main-content -->
    <script src="assets/js/sidebar.js"></script>
</body>
    </html>
    ');
}

// Processar cadastro
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // ✅ CORREÇÃO 1: Usar htmlspecialchars() ao invés de FILTER_SANITIZE_STRING (deprecated)
        $nome_convidado = htmlspecialchars(trim($_POST['nome'] ?? ''), ENT_QUOTES, 'UTF-8');
        $email_convidado = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
        $whatsapp = preg_replace('/[^0-9]/', '', $_POST['whatsapp'] ?? ''); // Remove tudo exceto números
        $dia_nascimento = intval($_POST['dia_nascimento'] ?? 0);
        $mes_nascimento = intval($_POST['mes_nascimento'] ?? 0);
        
        // Validações
        if (empty($nome_convidado)) {
            $erro = 'Nome é obrigatório.';
        } elseif (empty($whatsapp) || strlen($whatsapp) < 10) {
            $erro = 'WhatsApp inválido. Insira um número válido com DDD.';
        } elseif (!filter_var($email_convidado, FILTER_VALIDATE_EMAIL)) {
            $erro = 'Email inválido. Por favor, insira um email válido.';
        } elseif ($dia_nascimento < 1 || $dia_nascimento > 31) {
            $erro = 'Dia de nascimento inválido.';
        } elseif ($mes_nascimento < 1 || $mes_nascimento > 12) {
            $erro = 'Mês de nascimento inválido.';
        } else {
            // ✅ CORREÇÃO 2: Salvar no formato DATE do MySQL (YYYY-MM-DD)
            // Como não temos o ano, vamos usar o ano atual apenas como placeholder
            $ano_atual = date('Y');
            $data_nascimento = sprintf('%s-%02d-%02d', $ano_atual, $mes_nascimento, $dia_nascimento);
            
            // Validar se a data é válida
            if (!checkdate($mes_nascimento, $dia_nascimento, $ano_atual)) {
                $erro = 'Data de nascimento inválida. Verifique o dia e mês informados.';
            } else{
                // Gerar QR Code único
                $qr_code = 'QR' . strtoupper(uniqid()) . '-E' . $convite['evento_id'];
                
                // Inserir no banco
                $stmt = $pdo->prepare("
                    INSERT INTO convidados (nome, whatsapp, email, data_nascimento, qr_code, promoter_id, evento_id) 
                    VALUES (?, ?, ?, ?, ?, ?, ?)
                ");
                
                if ($stmt->execute([$nome_convidado, $whatsapp, $email_convidado, $data_nascimento, $qr_code, $convite['user_id'], $convite['evento_id']])) {
                    $sucesso = true;
                    $qr_code_gerado = $qr_code;
                    
                    // Enviar email
                    try {
                        $link_qrcode = 'https://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/baixar_qrcode.php?qr=' . $qr_code;
                        
                        $evento_info = [
                            'evento_nome' => $convite['evento_nome'],
                            'data' => $convite['data'],
                            'hora' => $convite['hora'],
                            'informacoes_importantes' => $convite['informacoes_importantes'] ?? '',
                            'promoter_nome' => $convite['promoter_nome']
                        ];
                        
                        if (function_exists('enviarEmailConvite')) {
                            enviarEmailConvite($email_convidado, $nome_convidado, $evento_info, $qr_code, $link_qrcode);
                        }
                    } catch (Exception $e) {
                        error_log("Erro ao enviar email: " . $e->getMessage());
                    }
                } else {
                    $erro = 'Erro ao realizar cadastro. Tente novamente.';
                }
            }
        }
    } catch (Exception $e) {
        $erro = 'Erro: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Convite - <?= htmlspecialchars($convite['evento_nome']) ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #000 0%, #1a1a1a 100%);
            color: #fff;
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 600px;
            margin: 0 auto;
        }
        
        .evento-header {
            background: #2a2a2a;
            border-radius: 20px;
            overflow: hidden;
            margin-bottom: 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.5);
        }
        
        .evento-imagem {
            width: 100%;
            height: 300px;
            object-fit: cover;
        }
        
        .evento-imagem-placeholder {
            width: 100%;
            height: 300px;
            background: linear-gradient(135deg, #FFD700, #FFA500);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 80px;
        }
        
        .evento-info {
            padding: 30px;
        }
        
        .evento-nome {
            font-size: 32px;
            font-weight: bold;
            color: #FFD700;
            margin-bottom: 15px;
        }
        
        .info-item {
            font-size: 16px;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .promoter-badge {
            background: linear-gradient(135deg, #FFD700, #FFA500);
            color: #000;
            padding: 20px;
            border-radius: 15px;
            text-align: center;
            margin-bottom: 30px;
            box-shadow: 0 5px 20px rgba(255, 215, 0, 0.3);
        }
        
        .info-importantes {
            background: #1a1a1a;
            border: 2px solid #FFD700;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 30px;
        }
        
        .info-importantes h3 {
            color: #FFD700;
            margin-bottom: 15px;
        }
        
        .info-importantes p {
            line-height: 1.8;
            white-space: pre-line;
        }
        
        .card {
            background: #2a2a2a;
            border-radius: 20px;
            padding: 30px;
            margin-bottom: 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.5);
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            color: #FFD700;
            font-weight: 600;
        }
        
        input, select {
            width: 100%;
            padding: 15px;
            border: 2px solid #333;
            border-radius: 10px;
            background: #1a1a1a;
            color: #fff;
            font-size: 16px;
            transition: all 0.3s;
        }
        
        input:focus, select:focus {
            outline: none;
            border-color: #FFD700;
            box-shadow: 0 0 0 3px rgba(255, 215, 0, 0.1);
        }
        
        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
        }
        
        .btn {
            width: 100%;
            padding: 18px;
            border: none;
            border-radius: 10px;
            background: linear-gradient(135deg, #FFD700, #FFA500);
            color: #000;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(255, 215, 0, 0.5);
        }
        
        .sucesso-container {
            text-align: center;
        }
        
        .sucesso-icon {
            font-size: 80px;
            margin-bottom: 20px;
            animation: bounce 1s infinite;
        }
        
        @keyframes bounce {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-20px); }
        }
        
        .qr-code-container {
            background: #fff;
            padding: 30px;
            border-radius: 15px;
            margin: 20px 0;
        }
        
        #qrcode {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }
        
        .qr-text {
            background: #000;
            color: #FFD700;
            padding: 15px;
            border-radius: 10px;
            font-family: monospace;
            font-size: 14px;
            word-break: break-all;
            margin-top: 15px;
        }
        
        .info-box {
            background: #1a1a1a;
            padding: 20px;
            border-radius: 15px;
            margin: 20px 0;
        }
        
        .footer {
            text-align: center;
            padding: 30px;
            color: #999;
            font-size: 14px;
        }
        
        .alert-error {
            background: rgba(255, 68, 68, 0.1);
            border: 2px solid #ff4444;
            color: #ff4444;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .alert-warning {
            background: rgba(255, 165, 0, 0.1);
            border: 2px solid #FFA500;
            color: #FFA500;
            padding: 15px;
            border-radius: 10px;
            margin-top: 10px;
            font-size: 14px;
        }
        
        .btn-download {
            background: #007bff;
            color: white;
            margin-top: 10px;
            text-decoration: none;
            display: block;
            text-align: center;
        }
        
        .email-badge {
            background: rgba(0, 200, 81, 0.1);
            border: 2px solid #00C851;
            color: #00C851;
            padding: 15px;
            border-radius: 10px;
            margin: 20px 0;
            text-align: center;
        }
        
        small.hint {
            display: block;
            color: #999;
            font-size: 13px;
            margin-top: 5px;
        }
        
        @media (max-width: 768px) {
            .form-row {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <?php if (!$sucesso): ?>
            <div class="evento-header">
                <?php if (!empty($convite['imagem']) && file_exists($convite['imagem'])): ?>
                    <img src="<?= htmlspecialchars($convite['imagem']) ?>" class="evento-imagem" alt="Evento">
                <?php else: ?>
                    <div class="evento-imagem-placeholder"><i class="fas fa-glass-cheers" style="font-size: 80px;"></i></div>
                <?php endif; ?>
                
                <div class="evento-info">
                    <div class="evento-nome"><?= htmlspecialchars($convite['evento_nome']) ?></div>
                    <div class="info-item"><i class="fas fa-calendar-alt"></i> <?= formatarData($convite['data']) ?></div>
                    <div class="info-item"><i class="fas fa-clock"></i> <?= date('H:i', strtotime($convite['hora'])) ?></div>
                </div>
            </div>
            
            <div class="promoter-badge">
                <div style="font-size: 14px; margin-bottom: 5px; opacity: 0.9;">Você foi convidado por:</div>
                <div style="font-size: 24px; font-weight: bold;"><?= htmlspecialchars($convite['promoter_nome']) ?></div>
            </div>
            
            <?php if (!empty($convite['informacoes_importantes'])): ?>
            <div class="info-importantes">
                <h3><i class="fas fa-clipboard-list"></i> Informações Importantes</h3>
                <p><?= nl2br(htmlspecialchars($convite['informacoes_importantes'])) ?></p>
            </div>
            <?php endif; ?>
            
            <div class="card">
                <h2 style="color: #FFD700; margin-bottom: 20px; text-align: center;"><i class="fas fa-star"></i> Complete seu Cadastro</h2>
                
                <?php if ($erro): ?>
                    <div class="alert-error"><?= htmlspecialchars($erro) ?></div>
                <?php endif; ?>
                
                <form method="POST">
                    <div class="form-group">
                        <label>Nome Completo *</label>
                        <input type="text" name="nome" required placeholder="Seu nome completo" value="<?= isset($_POST['nome']) ? htmlspecialchars($_POST['nome']) : '' ?>">
                    </div>
                    
                    <div class="form-group">
                        <label>WhatsApp *</label>
                        <input type="tel" name="whatsapp" required placeholder="(00) 00000-0000"
                               maxlength="20" value="<?= isset($_POST['whatsapp']) ? htmlspecialchars($_POST['whatsapp']) : '' ?>">
                        <small class="hint"><i class="fas fa-phone"></i> Apenas para contato em caso de necessidade</small>
                    </div>
                    
                    <div class="form-group">
                        <label>Email *</label>
                        <input type="email" name="email" required placeholder="seu@email.com" value="<?= isset($_POST['email']) ? htmlspecialchars($_POST['email']) : '' ?>">
                        <div class="alert-warning">
                            <i class="fas fa-exclamation-triangle"></i> <strong>ATENÇÃO:</strong> Você receberá seu convite neste email. Confira se está correto!
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Data de Nascimento (Dia e Mês) *</label>
                        <div class="form-row">
                            <select name="dia_nascimento" required>
                                <option value="">Dia</option>
                                <?php for($i = 1; $i <= 31; $i++): ?>
                                    <option value="<?= $i ?>" <?= (isset($_POST['dia_nascimento']) && $_POST['dia_nascimento'] == $i) ? 'selected' : '' ?>>
                                        <?= str_pad($i, 2, '0', STR_PAD_LEFT) ?>
                                    </option>
                                <?php endfor; ?>
                            </select>
                            
                            <select name="mes_nascimento" required>
                                <option value="">Mês</option>
                                <?php 
                                $meses = ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 
                                         'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'];
                                for($i = 1; $i <= 12; $i++): 
                                ?>
                                    <option value="<?= $i ?>" <?= (isset($_POST['mes_nascimento']) && $_POST['mes_nascimento'] == $i) ? 'selected' : '' ?>>
                                        <?= $meses[$i-1] ?>
                                    </option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        <small class="hint"><i class="fas fa-birthday-cake"></i> Usado para aniversariantes do mês</small>
                    </div>

                    <button type="submit" class="btn">Confirmar Presença <i class="fas fa-check"></i></button>
                </form>
            </div>
        <?php else: ?>
            <div class="card sucesso-container">
                <div class="sucesso-icon"><i class="fas fa-check-circle" style="color: #00C851;"></i></div>
                <h1 style="color: #FFD700; margin-bottom: 20px;">Cadastro Confirmado!</h1>
                <p style="font-size: 18px; margin-bottom: 30px;">
                    Sua presença foi confirmada com sucesso!
                </p>
                
                <div class="email-badge">
                    <strong><i class="fas fa-envelope"></i> Email enviado para:</strong><br>
                    <?= htmlspecialchars($email_convidado) ?>
                    <p style="margin-top: 10px; font-size: 14px;">
                        Verifique sua caixa de entrada e spam!
                    </p>
                </div>
                
                <div class="info-box">
                    <h3 style="color: #FFD700; margin-bottom: 15px;"><i class="fas fa-exclamation-triangle"></i> MUITO IMPORTANTE</h3>
                    <p style="margin-bottom: 15px;">
                        <strong>SEU INGRESSO FOI ENVIADO POR EMAIL!</strong><br>
                        Você precisará apresentá-lo na entrada do evento.
                    </p>
                    
                    <div class="qr-code-container">
                        <div id="qrcode"></div>
                        <div class="qr-text">CÓDIGO: <?= $qr_code_gerado ?></div>
                    </div>
                    
                    <p style="font-size: 14px; color: #999; text-align: center; margin-bottom: 15px;">
                        <i class="fas fa-mobile-alt"></i> Tire um print desta tela ou salve este código<br>
                        <i class="fas fa-save"></i> Guarde em local seguro
                    </p>

                    <a href="baixar_qrcode.php?qr=<?= $qr_code_gerado ?>" class="btn btn-download">
                        <i class="fas fa-download"></i> Baixar Ingresso Completo
                    </a>
                </div>
                
                <?php if (!empty($convite['informacoes_importantes'])): ?>
                <div class="info-importantes">
                    <h3><i class="fas fa-clipboard-list"></i> Informações Importantes</h3>
                    <p><?= nl2br(htmlspecialchars($convite['informacoes_importantes'])) ?></p>
                </div>
                <?php endif; ?>

                <div style="background: linear-gradient(135deg, #FFD700, #FFA500); color: #000; padding: 25px; border-radius: 15px; margin-top: 20px;">
                    <h3 style="margin-bottom: 15px;"><i class="fas fa-ticket-alt"></i> Detalhes do Evento</h3>
                    <p style="font-size: 18px; margin-bottom: 5px;">
                        <strong><?= htmlspecialchars($convite['evento_nome']) ?></strong>
                    </p>
                    <p style="font-size: 16px;">
                        <i class="fas fa-calendar-alt"></i> <?= formatarData($convite['data']) ?><br>
                        <i class="fas fa-clock"></i> <?= date('H:i', strtotime($convite['hora'])) ?>
                    </p>
                </div>

                <div style="margin-top: 30px; padding: 20px; background: #1a1a1a; border-radius: 10px;">
                    <p style="font-size: 14px; color: #FFD700; margin-bottom: 10px;">
                        <i class="fas fa-check-circle"></i> Cadastro realizado por: <strong><?= htmlspecialchars($convite['promoter_nome']) ?></strong>
                    </p>
                    <p style="font-size: 13px; color: #999;">
                        Qualquer dúvida, entre em contato com quem te convidou!
                    </p>
                </div>
            </div>
        <?php endif; ?>
        
        <div class="footer">
            Desenvolvido por <strong>Alerson Araújo</strong><br>
            Todos os direitos reservados<br>
            Licenciado para <strong>Espaço Taal</strong>
        </div>
    </div>
    
    <?php if ($sucesso): ?>
    <script>
        // Gerar QR Code
        new QRCode(document.getElementById("qrcode"), {
            text: "<?= $qr_code_gerado ?>",
            width: 250,
            height: 250,
            colorDark: "#000000",
            colorLight: "#ffffff",
            correctLevel: QRCode.CorrectLevel.H
        });
    </script>
    <?php endif; ?>
    </div><!-- /.main-content -->
    <script src="assets/js/sidebar.js"></script>
</body>
</html>