<?php
// debug_notificacoes.php - Script de diagnóstico
require_once 'config.php';
verificarLogin();

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];

echo "<h1>Debug - Sistema de Notificações v3.0</h1>";
echo "<p><strong>User ID:</strong> $user_id | <strong>Role:</strong> $role</p>";
echo "<hr>";

// Verificar dados do usuário
echo "<h2>1. Dados do Usuário</h2>";
$stmt = $pdo->prepare("SELECT id, nome, role, mensagens_nao_lidas, notificacoes_nao_lidas FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();
echo "<pre>";
print_r($usuario);
echo "</pre>";
echo "<hr>";

// Verificar mensagens_destinatarios
echo "<h2>2. Mensagens Destinatários</h2>";
$stmt = $pdo->prepare("
    SELECT md.*, m.assunto, m.remetente_nome
    FROM mensagens_destinatarios md
    INNER JOIN mensagens m ON md.mensagem_id = m.id
    WHERE md.destinatario_id = ?
    ORDER BY md.created_at DESC
    LIMIT 10
");
$stmt->execute([$user_id]);
$mensagens_dest = $stmt->fetchAll();
echo "<p><strong>Total:</strong> " . count($mensagens_dest) . "</p>";
echo "<pre>";
print_r($mensagens_dest);
echo "</pre>";
echo "<hr>";

// Verificar notificações
echo "<h2>3. Notificações</h2>";
$stmt = $pdo->prepare("
    SELECT * FROM notificacoes
    WHERE user_id = ?
    ORDER BY created_at DESC
    LIMIT 10
");
$stmt->execute([$user_id]);
$notificacoes = $stmt->fetchAll();
echo "<p><strong>Total:</strong> " . count($notificacoes) . "</p>";
echo "<pre>";
print_r($notificacoes);
echo "</pre>";
echo "<hr>";

// Verificar query da página mensagens.php
echo "<h2>4. Query da Página mensagens.php</h2>";
$stmt = $pdo->prepare("
    SELECT m.*, md.lida, md.lida_em, md.arquivada
    FROM mensagens m
    INNER JOIN mensagens_destinatarios md ON m.id = md.mensagem_id
    WHERE md.destinatario_id = ?
    AND md.arquivada = 0
    ORDER BY m.created_at DESC
    LIMIT 100
");
$stmt->execute([$user_id]);
$mensagens_pagina = $stmt->fetchAll();
echo "<p><strong>Total:</strong> " . count($mensagens_pagina) . "</p>";
echo "<pre>";
print_r($mensagens_pagina);
echo "</pre>";
echo "<hr>";

// Verificar se as tabelas existem
echo "<h2>5. Verificar Estrutura das Tabelas</h2>";
try {
    $tables = ['mensagens', 'mensagens_destinatarios', 'notificacoes', 'user_status'];
    foreach ($tables as $table) {
        $stmt = $pdo->query("SHOW TABLES LIKE '$table'");
        $exists = $stmt->fetch();
        echo "<p><strong>$table:</strong> " . ($exists ? "✅ Existe" : "❌ Não existe") . "</p>";

        if ($exists) {
            $stmt = $pdo->query("SELECT COUNT(*) as total FROM $table");
            $count = $stmt->fetch();
            echo "<p>→ Total de registros: {$count['total']}</p>";
        }
    }
} catch (Exception $e) {
    echo "<p style='color:red'>Erro: " . $e->getMessage() . "</p>";
}
echo "<hr>";

// Verificar colunas da tabela users
echo "<h2>6. Colunas da Tabela Users</h2>";
$stmt = $pdo->query("DESCRIBE users");
$columns = $stmt->fetchAll();
echo "<pre>";
foreach ($columns as $col) {
    echo "{$col['Field']} - {$col['Type']}\n";
}
echo "</pre>";

echo "<hr>";
echo "<p><a href='dashboard.php'>← Voltar ao Dashboard</a></p>";
?>
