<?php
// eventos.php - PADRONIZADO COM DESIGN DA DASHBOARD
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

require_once 'config.php';
verificarLogin();

$user_id = $_SESSION['user_id'];
$sucesso = '';
$erro = '';

// Participar de evento
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['participar'])) {
    $evento_id = intval($_POST['evento_id']);
    
    // Verificar se já participa
    $stmt = $pdo->prepare("SELECT id FROM produtor_eventos WHERE user_id = ? AND evento_id = ?");
    $stmt->execute([$user_id, $evento_id]);
    
    if (!$stmt->fetch()) {
        // Gerar link exclusivo
        $link_exclusivo = gerarToken(16);
        
        $stmt = $pdo->prepare("INSERT INTO produtor_eventos (user_id, evento_id, link_exclusivo) VALUES (?, ?, ?)");
        if ($stmt->execute([$user_id, $evento_id, $link_exclusivo])) {
            $sucesso = 'Você agora participa deste evento! Seu link foi gerado.';
        } else {
            $erro = 'Erro ao participar do evento.';
        }
    } else {
        $erro = 'Você já participa deste evento!';
    }
}

// Buscar eventos disponíveis (que o promoter NÃO participa)
$stmt = $pdo->prepare("
    SELECT e.*,
    (SELECT COUNT(*) FROM evento_arquivos ea WHERE ea.evento_id = e.id) as total_arquivos
    FROM eventos e
    WHERE e.status = 'ativo' 
    AND e.id NOT IN (
        SELECT evento_id FROM produtor_eventos WHERE user_id = ?
    )
    ORDER BY e.data ASC
");
$stmt->execute([$user_id]);
$eventos_disponiveis = $stmt->fetchAll();

// Buscar meus eventos (que o promoter JÁ participa)
$stmt = $pdo->prepare("
    SELECT e.*, pe.link_exclusivo, pe.id as participacao_id,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = ? AND c.evento_id = e.id) as meus_convidados,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = ? AND c.evento_id = e.id AND c.checkin = 1) as meus_checkins,
    (SELECT COUNT(*) FROM evento_arquivos ea WHERE ea.evento_id = e.id) as total_arquivos
    FROM eventos e
    INNER JOIN produtor_eventos pe ON e.id = pe.evento_id
    WHERE pe.user_id = ?
    ORDER BY e.data ASC
");
$stmt->execute([$user_id, $user_id, $user_id]);
$meus_eventos = $stmt->fetchAll();

// Buscar dados do usuário para sidebar
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="pt-BR" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    
    <title>Eventos - Sistema Promoters</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">
    <link rel="stylesheet" href="assets/css/sidebar.css">

    <style>
        .section {
            margin-bottom: 50px;
        }
        .eventos-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
            gap: 25px;
        }
        
        .evento-card {
            background: var(--bg-card);
            border: 2px solid var(--border-color);
            border-radius: 15px;
            overflow: hidden;
            transition: all 0.3s ease;
        }
        
        .evento-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 40px rgba(255, 215, 0, 0.3);
            border-color: var(--color-gold);
        }

        .evento-imagem {
            width: 100%;
            height: 200px;
            object-fit: cover;
            background: var(--bg-secondary);
        }
        
        .evento-body {
            padding: 25px;
        }
        
        .evento-titulo {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 15px;
            color: var(--color-gold);
        }
        
        .evento-info {
            font-size: 14px;
            color: var(--text-secondary);
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .evento-stats {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin: 20px 0;
            padding: 20px 0;
            border-top: 2px solid var(--border-color);
            border-bottom: 2px solid var(--border-color);
        }
        
        .stat-item {
            text-align: center;
        }
        
        .stat-value {
            font-size: 32px;
            font-weight: 700;
            color: var(--color-gold);
        }
        
        .stat-label {
            font-size: 11px;
            color: var(--text-secondary);
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-top: 5px;
        }
        .link-box {
            background: var(--bg-primary);
            padding: 18px;
            border-radius: 12px;
            margin: 20px 0;
            border: 2px solid var(--border-color);
        }
        
        .link-label {
            font-size: 12px;
            color: var(--text-secondary);
            margin-bottom: 10px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .link-content {
            display: flex;
            gap: 10px;
            align-items: center;
        }
        
        .link-input {
            flex: 1;
            padding: 12px;
            background: var(--bg-secondary);
            border: 2px solid var(--border-color);
            border-radius: 10px;
            color: var(--text-primary);
            font-size: 12px;
            font-family: 'Courier New', monospace;
        }
        
        .link-input:focus {
            outline: none;
            border-color: var(--color-gold);
        }
        
        .btn-copy {
            padding: 12px 20px;
            background: var(--color-gold);
            color: #000;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            font-weight: 600;
            font-size: 12px;
            transition: all 0.3s;
        }
        
        .btn-copy:hover {
            background: var(--color-gold-dark);
            transform: translateY(-2px);
        }
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.85);
            z-index: 2000;
            overflow-y: auto;
            backdrop-filter: blur(5px);
        }
        
        .modal.active {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .modal-content {
            background: var(--bg-card);
            border-radius: 20px;
            padding: 35px;
            max-width: 700px;
            width: 100%;
            max-height: 85vh;
            overflow-y: auto;
            border: 2px solid var(--border-gold);
            box-shadow: 0 20px 60px rgba(0,0,0,0.5);
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            padding-bottom: 20px;
            border-bottom: 2px solid var(--border-color);
        }
        
        .modal-title {
            font-size: 26px;
            font-weight: 700;
            color: var(--color-gold);
        }
        
        .close-modal {
            background: none;
            border: none;
            font-size: 32px;
            cursor: pointer;
            color: var(--text-secondary);
            transition: all 0.3s;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 10px;
        }
        
        .close-modal:hover {
            color: var(--color-gold);
            background: var(--bg-secondary);
        }
        
        .arquivo-item {
            background: var(--bg-primary);
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border: 2px solid var(--border-color);
            transition: all 0.3s;
        }
        
        .arquivo-item:hover {
            border-color: var(--border-gold);
            transform: translateX(5px);
        }
        
        .arquivo-nome {
            font-weight: 600;
            margin-bottom: 8px;
            font-size: 15px;
        }
        
        .arquivo-info {
            font-size: 12px;
            color: var(--text-secondary);
        }
        
        @media (max-width: 768px) {
            .eventos-grid {
                grid-template-columns: 1fr;
            }
            
            .modal-content {
                padding: 25px;
            }
            
            .link-content {
                flex-direction: column;
            }
            
            .btn-copy {
                width: 100%;
            }
        }
    </style>
</head>
<body>

    <?php include 'assets/sidebar.php'; ?>

    <div class="container">

        <div class="welcome-section">
            <h1 class="welcome-title">
                <i class="fas fa-calendar-alt"></i>
                Eventos Disponíveis
            </h1>
            <p class="welcome-subtitle">
                Participe de eventos e ganhe comissões por check-ins
            </p>
        </div>
        <?php if ($sucesso): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?= htmlspecialchars($sucesso) ?>
            </div>
        <?php endif; ?>
        
        <?php if ($erro): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i>
                <?= htmlspecialchars($erro) ?>
            </div>
        <?php endif; ?>
        
        <!-- MEUS EVENTOS -->
        <div class="section">
            <div class="section-title">
                <i class="fas fa-star"></i>
                Meus Eventos Ativos
            </div>
            
            <?php if (count($meus_eventos) > 0): ?>
                <div class="eventos-grid">
                    <?php foreach ($meus_eventos as $evento): 
                        $link_completo = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/convite.php?link=" . $evento['link_exclusivo'];
                    ?>
                        <div class="evento-card">
                            <?php if ($evento['imagem']): ?>
                                <img src="<?= htmlspecialchars($evento['imagem']) ?>" class="evento-imagem" alt="<?= htmlspecialchars($evento['nome']) ?>">
                            <?php else: ?>
                                <div class="evento-imagem" style="display: flex; align-items: center; justify-content: center; font-size: 56px;">
                                    <i class="fas fa-calendar-star" style="color: var(--color-gold);"></i>
                                </div>
                            <?php endif; ?>
                            
                            <div class="evento-body">
                                <div class="evento-titulo"><?= htmlspecialchars($evento['nome']) ?></div>
                                
                                <div class="evento-info">
                                    <i class="fas fa-calendar-alt"></i>
                                    <?= formatarData($evento['data']) ?>
                                </div>
                                
                                <div class="evento-info">
                                    <i class="fas fa-clock"></i>
                                    <?= date('H:i', strtotime($evento['hora'])) ?>
                                </div>
                                
                                <div class="evento-info" style="color: var(--color-gold);">
                                    <i class="fas fa-wallet"></i>
                                    Comissão: <?= formatarMoeda($evento['valor_comissao']) ?>/check-in
                                </div>
                                
                                <?php if ($evento['total_arquivos'] > 0): ?>
                                    <div class="evento-info" style="color: var(--color-gold);">
                                        <i class="fas fa-paperclip"></i>
                                        <?= $evento['total_arquivos'] ?> material(is) disponível(is)
                                    </div>
                                <?php endif; ?>
                                
                                <div class="evento-stats">
                                    <div class="stat-item">
                                        <div class="stat-value"><?= $evento['meus_convidados'] ?></div>
                                        <div class="stat-label">Convidados</div>
                                    </div>
                                    <div class="stat-item">
                                        <div class="stat-value"><?= $evento['meus_checkins'] ?></div>
                                        <div class="stat-label">Check-ins</div>
                                    </div>
                                </div>
                                
                                <div class="link-box">
                                    <div class="link-label">
                                        <i class="fas fa-link"></i> Seu Link Exclusivo:
                                    </div>
                                    <div class="link-content">
                                        <input type="text" class="link-input" value="<?= $link_completo ?>" readonly id="link_<?= $evento['id'] ?>">
                                        <button class="btn-copy" onclick="copiarLink('link_<?= $evento['id'] ?>')">
                                            <i class="fas fa-copy"></i> Copiar
                                        </button>
                                    </div>
                                </div>
                                
                                <?php if ($evento['total_arquivos'] > 0): ?>
                                    <button class="btn btn-secondary" onclick="verMateriais(<?= $evento['id'] ?>, '<?= htmlspecialchars($evento['nome']) ?>')">
                                        <i class="fas fa-download"></i> Baixar Materiais (<?= $evento['total_arquivos'] ?>)
                                    </button>
                                <?php endif; ?>
                                
                                <a href="minhas_listas.php?evento_id=<?= $evento['id'] ?>" class="btn btn-secondary">
                                    <i class="fas fa-list-ul"></i> Ver Lista Completa
                                </a>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <div class="empty-state-icon">
                        <i class="fas fa-calendar-times"></i>
                    </div>
                    <h3>Você ainda não participa de nenhum evento</h3>
                    <p>Participe dos eventos disponíveis abaixo!</p>
                </div>
            <?php endif; ?>
        </div>
        
        <!-- EVENTOS DISPONÍVEIS -->
        <div class="section">
            <div class="section-title">
                <i class="fas fa-calendar-plus"></i>
                Eventos Disponíveis
            </div>
            
            <?php if (count($eventos_disponiveis) > 0): ?>
                <div class="eventos-grid">
                    <?php foreach ($eventos_disponiveis as $evento): ?>
                        <div class="evento-card">
                            <?php if ($evento['imagem']): ?>
                                <img src="<?= htmlspecialchars($evento['imagem']) ?>" class="evento-imagem" alt="<?= htmlspecialchars($evento['nome']) ?>">
                            <?php else: ?>
                                <div class="evento-imagem" style="display: flex; align-items: center; justify-content: center; font-size: 56px;">
                                    <i class="fas fa-calendar-star" style="color: var(--color-gold);"></i>
                                </div>
                            <?php endif; ?>
                            
                            <div class="evento-body">
                                <div class="evento-titulo"><?= htmlspecialchars($evento['nome']) ?></div>
                                
                                <div class="evento-info">
                                    <i class="fas fa-calendar-alt"></i>
                                    <?= formatarData($evento['data']) ?>
                                </div>
                                
                                <div class="evento-info">
                                    <i class="fas fa-clock"></i>
                                    <?= date('H:i', strtotime($evento['hora'])) ?>
                                </div>
                                
                                <div class="evento-info" style="color: var(--color-gold);">
                                    <i class="fas fa-wallet"></i>
                                    Comissão: <?= formatarMoeda($evento['valor_comissao']) ?>/check-in
                                </div>
                                
                                <div class="evento-info">
                                    <i class="fas fa-users"></i>
                                    Mínimo: <?= $evento['minimo_lista'] ?> convidados para comissão
                                </div>
                                
                                <?php if ($evento['total_arquivos'] > 0): ?>
                                    <div class="evento-info" style="color: var(--color-gold);">
                                        <i class="fas fa-paperclip"></i>
                                        <?= $evento['total_arquivos'] ?> material(is) para divulgação
                                    </div>
                                <?php endif; ?>
                                
                                <form method="POST" style="margin-top: 20px;">
                                    <input type="hidden" name="evento_id" value="<?= $evento['id'] ?>">
                                    <button type="submit" name="participar" class="btn btn-primary">
                                        <i class="fas fa-plus-circle"></i> Participar deste Evento
                                    </button>
                                </form>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <div class="empty-state-icon">
                        <i class="fas fa-inbox"></i>
                    </div>
                    <h3>Nenhum evento disponível no momento</h3>
                    <p>Aguarde novos eventos serem criados pelo administrador.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Modal Materiais -->
    <div id="modalMateriais" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title" id="materiais_titulo">
                    <i class="fas fa-folder-open"></i> Materiais do Evento
                </div>
                <button class="close-modal" onclick="closeModal()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <div id="materiais_content"></div>
        </div>
    </div>
    
    <script>
        function copiarLink(inputId) {
            const input = document.getElementById(inputId);
            input.select();
            input.setSelectionRange(0, 99999);
            
            try {
                document.execCommand('copy');
                alert('Link copiado com sucesso!');
            } catch (err) {
                alert('Erro ao copiar. Selecione e copie manualmente.');
            }
        }
        
        function verMateriais(eventoId, eventoNome) {
            document.getElementById('materiais_titulo').innerHTML = '<i class="fas fa-folder-open"></i> Materiais: ' + eventoNome;
            document.getElementById('materiais_content').innerHTML = '<p style="text-align: center; padding: 30px; color: var(--text-secondary);"><i class="fas fa-spinner fa-spin"></i> Carregando...</p>';
            document.getElementById('modalMateriais').classList.add('active');
            
            fetch('get_arquivos_evento.php?evento_id=' + eventoId)
                .then(response => response.json())
                .then(data => {
                    let html = '';
                    if (data.length > 0) {
                        data.forEach(arquivo => {
                            const tamanhoMB = (arquivo.tamanho_bytes / 1024 / 1024).toFixed(2);
                            html += `
                                <div class="arquivo-item">
                                    <div>
                                        <div class="arquivo-nome">
                                            <i class="fas fa-file"></i> ${arquivo.nome_arquivo}
                                        </div>
                                        <div class="arquivo-info">
                                            <i class="fas fa-weight"></i> ${tamanhoMB} MB
                                        </div>
                                    </div>
                                    <a href="${arquivo.caminho_arquivo}" download class="btn btn-primary" style="width: auto; padding: 12px 25px;">
                                        <i class="fas fa-download"></i> Baixar
                                    </a>
                                </div>
                            `;
                        });
                    } else {
                        html = '<div class="empty-state" style="padding: 40px;"><div class="empty-state-icon"><i class="fas fa-folder-open"></i></div><p>Nenhum material disponível</p></div>';
                    }
                    
                    document.getElementById('materiais_content').innerHTML = html;
                })
                .catch(error => {
                    console.error('Erro:', error);
                    document.getElementById('materiais_content').innerHTML = '<p style="color: #ff4444; text-align: center; padding: 30px;"><i class="fas fa-exclamation-triangle"></i><br><br>Erro ao carregar materiais</p>';
                });
        }
        
        function closeModal() {
            document.getElementById('modalMateriais').classList.remove('active');
        }
        
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                closeModal();
            }
        }
    </script>
    </div><!-- /.main-content -->
    <script src="assets/js/sidebar.js"></script>
</body>
</html>