<?php
// login.php
require_once 'config.php';

$erro = '';
$sucesso = '';

// Buscar configurações do sistema
$stmt = $pdo->query("SELECT * FROM configuracoes WHERE id = 1");
$config = $stmt->fetch();

// Processar login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
    $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
    $senha = $_POST['senha'];
    
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? AND status = 'aprovado'");
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    
    if ($user && password_verify($senha, $user['senha'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['nome'] = $user['nome'];
        $_SESSION['role'] = $user['role'];
        header('Location: dashboard.php');
        exit;
    } else {
        $erro = 'Email ou senha incorretos, ou conta não aprovada.';
    }
}

// Processar registro
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['registro'])) {
    $nome = filter_input(INPUT_POST, 'nome', FILTER_SANITIZE_STRING);
    $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
    $senha = password_hash($_POST['senha'], PASSWORD_DEFAULT);
    $telefone = filter_input(INPUT_POST, 'telefone', FILTER_SANITIZE_STRING);
    $instagram = filter_input(INPUT_POST, 'instagram', FILTER_SANITIZE_STRING);
    $cidade = filter_input(INPUT_POST, 'cidade', FILTER_SANITIZE_STRING);
    $bairro = filter_input(INPUT_POST, 'bairro', FILTER_SANITIZE_STRING);
    $idade = filter_input(INPUT_POST, 'idade', FILTER_SANITIZE_NUMBER_INT);
    
    // Upload da foto de perfil
    $foto_perfil = '';
    if (isset($_FILES['foto_perfil']) && $_FILES['foto_perfil']['error'] == 0) {
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];
        $filename = $_FILES['foto_perfil']['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if (in_array($ext, $allowed)) {
            $novo_nome = uniqid() . '.' . $ext;
            $destino = 'uploads/perfis/' . $novo_nome;
            
            if (move_uploaded_file($_FILES['foto_perfil']['tmp_name'], $destino)) {
                $foto_perfil = $destino;
            }
        }
    }
    
    if (empty($foto_perfil)) {
        $erro = 'A foto de perfil é obrigatória.';
    } else {
        // Verificar se email já existe
        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->execute([$email]);
        
        if ($stmt->fetch()) {
            $erro = 'Este email já está cadastrado.';
        } else {
            $stmt = $pdo->prepare("INSERT INTO users (nome, email, senha, telefone, instagram, cidade, bairro, idade, foto_perfil) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            if ($stmt->execute([$nome, $email, $senha, $telefone, $instagram, $cidade, $bairro, $idade, $foto_perfil])) {
                $sucesso = 'Cadastro realizado com sucesso! Aguarde aprovação do administrador.';
            } else {
                $erro = 'Erro ao realizar cadastro.';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?= htmlspecialchars($config['nome_sistema'] ?? 'Sistema Promoters') ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">
    <style>
        body {
            background: var(--bg-gradient);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
            overflow: hidden;
        }

        body::before {
            content: '';
            position: absolute;
            width: 500px;
            height: 500px;
            background: radial-gradient(circle, rgba(255, 215, 0, 0.1) 0%, transparent 70%);
            top: -250px;
            right: -250px;
            animation: pulse 4s ease-in-out infinite;
        }

        body::after {
            content: '';
            position: absolute;
            width: 400px;
            height: 400px;
            background: radial-gradient(circle, rgba(255, 215, 0, 0.08) 0%, transparent 70%);
            bottom: -200px;
            left: -200px;
            animation: pulse 4s ease-in-out infinite 2s;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); opacity: 1; }
            50% { transform: scale(1.1); opacity: 0.8; }
        }

        .login-container {
            width: 100%;
            max-width: 480px;
            position: relative;
            z-index: 1;
        }

        .login-card {
            background: var(--bg-card);
            border-radius: 24px;
            overflow: hidden;
            box-shadow: var(--shadow-xl);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 215, 0, 0.1);
            animation: slideUp 0.6s cubic-bezier(0.16, 1, 0.3, 1);
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .logo-section {
            padding: 40px 40px 20px;
            text-align: center;
            background: linear-gradient(180deg, rgba(255, 215, 0, 0.05) 0%, transparent 100%);
        }

        .logo-wrapper {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 80px;
            height: 80px;
            background: var(--primary-gradient);
            border-radius: 20px;
            margin-bottom: 20px;
            box-shadow: 0 8px 24px rgba(255, 215, 0, 0.25);
            animation: logoFloat 3s ease-in-out infinite;
        }

        @keyframes logoFloat {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }

        .logo-wrapper img {
            width: 50px;
            height: 50px;
            object-fit: contain;
        }

        .logo-text {
            font-size: 28px;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: 8px;
            letter-spacing: -0.5px;
        }

        .logo-subtitle {
            font-size: 14px;
            color: var(--text-secondary);
            font-weight: 500;
        }

        .tabs {
            display: flex;
            padding: 0 40px;
            gap: 12px;
            margin-top: 30px;
        }

        .tab {
            flex: 1;
            padding: 14px;
            text-align: center;
            cursor: pointer;
            border: none;
            background: transparent;
            color: var(--text-secondary);
            font-size: 15px;
            font-weight: 600;
            border-radius: 12px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
        }

        .tab:hover {
            color: var(--color-primary);
            background: rgba(255, 215, 0, 0.05);
        }

        .tab.active {
            color: var(--bg-primary);
            background: var(--primary-gradient);
            box-shadow: 0 4px 12px rgba(255, 215, 0, 0.3);
        }

        .form-container {
            padding: 30px 40px 40px;
        }

        .form-content {
            display: none;
        }

        .form-content.active {
            display: block;
            animation: fadeIn 0.4s ease-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .input-group {
            margin-bottom: 20px;
        }

        .input-label {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 10px;
            font-size: 13px;
            font-weight: 600;
            color: var(--text-secondary);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .input-wrapper {
            position: relative;
        }

        .input-icon {
            position: absolute;
            left: 16px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-tertiary);
            font-size: 18px;
            transition: color 0.3s;
            pointer-events: none;
        }

        .form-input {
            width: 100%;
            padding: 14px 16px 14px 48px;
            border: 2px solid var(--border-color);
            border-radius: 12px;
            background: var(--bg-input);
            color: var(--text-primary);
            font-size: 15px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .form-input:focus {
            outline: none;
            border-color: var(--color-primary);
            background: var(--bg-primary);
            box-shadow: 0 0 0 4px rgba(255, 215, 0, 0.1);
        }

        .form-input:focus + .input-icon {
            color: var(--color-primary);
        }

        .foto-perfil-wrapper {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 16px;
            padding: 24px;
            border: 2px dashed var(--border-color);
            border-radius: 16px;
            background: rgba(255, 215, 0, 0.02);
            margin-bottom: 20px;
            transition: all 0.3s;
        }

        .foto-perfil-wrapper:hover {
            border-color: var(--color-primary);
            background: rgba(255, 215, 0, 0.05);
        }

        .foto-preview {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            background: var(--bg-secondary);
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            border: 3px solid var(--border-color);
            transition: all 0.3s;
        }

        .foto-preview img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .foto-preview-icon {
            font-size: 40px;
            color: var(--text-tertiary);
        }

        .foto-input-label {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 20px;
            background: var(--bg-secondary);
            color: var(--text-primary);
            border-radius: 10px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s;
        }

        .foto-input-label:hover {
            background: rgba(255, 215, 0, 0.1);
            color: var(--color-primary);
        }

        .foto-input-label input {
            display: none;
        }

        .grid-2 {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 16px;
        }

        .btn-primary {
            width: 100%;
            padding: 16px;
            margin-top: 24px;
        }

        .alert {
            padding: 14px 18px;
            border-radius: 12px;
            margin-bottom: 20px;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 10px;
            animation: slideDown 0.4s ease-out;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .alert-error {
            background: rgba(255, 68, 68, 0.1);
            border: 1px solid rgba(255, 68, 68, 0.3);
            color: #ff4444;
        }

        .alert-success {
            background: rgba(0, 200, 81, 0.1);
            border: 1px solid rgba(0, 200, 81, 0.3);
            color: #00C851;
        }

        .footer-text {
            text-align: center;
            padding: 24px 40px;
            font-size: 12px;
            color: var(--text-tertiary);
            border-top: 1px solid var(--border-color);
        }

        .footer-text a {
            color: var(--color-primary);
            text-decoration: none;
            font-weight: 600;
            transition: opacity 0.3s;
        }

        .footer-text a:hover {
            opacity: 0.8;
        }

        @media (max-width: 768px) {
            .login-container {
                max-width: 100%;
            }

            .logo-section,
            .form-container,
            .tabs {
                padding-left: 24px;
                padding-right: 24px;
            }

            .grid-2 {
                grid-template-columns: 1fr;
            }

            .logo-text {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="logo-section">
                <div class="logo-wrapper">
                    <?php if (!empty($config['logo_sistema'])): ?>
                        <img src="<?= htmlspecialchars($config['logo_sistema']) ?>" alt="Logo">
                    <?php else: ?>
                        <i class="fas fa-theater-masks" style="font-size: 36px; color: #000;"></i>
                    <?php endif; ?>
                </div>
                <h1 class="logo-text"><?= htmlspecialchars($config['nome_sistema'] ?? 'Sistema Promoters') ?></h1>
                <p class="logo-subtitle">Espaço Taal</p>
            </div>

            <div class="tabs">
                <button class="tab active" onclick="switchTab('login')">
                    Login
                </button>
                <button class="tab" onclick="switchTab('registro')">
                    Cadastro
                </button>
            </div>

            <div class="form-container">
                <?php if ($erro): ?>
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-triangle"></i>
                        <?= htmlspecialchars($erro) ?>
                    </div>
                <?php endif; ?>

                <?php if ($sucesso): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i>
                        <?= htmlspecialchars($sucesso) ?>
                    </div>
                <?php endif; ?>

                <!-- Formulário de Login -->
                <div id="login" class="form-content active">
                    <form method="POST">
                        <div class="input-group">
                            <label class="input-label">Email</label>
                            <div class="input-wrapper">
                                <input type="email" name="email" class="form-input" placeholder="seu@email.com" required>
                                <span class="input-icon"><i class="fas fa-envelope"></i></span>
                            </div>
                        </div>

                        <div class="input-group">
                            <label class="input-label">Senha</label>
                            <div class="input-wrapper">
                                <input type="password" name="senha" class="form-input" placeholder="••••••••" required>
                                <span class="input-icon"><i class="fas fa-lock"></i></span>
                            </div>
                        </div>

                        <button type="submit" name="login" class="btn-primary">
                            <span>Entrar</span>
                            <span class="btn-icon"><i class="fas fa-arrow-right"></i></span>
                        </button>
                    </form>
                </div>

                <!-- Formulário de Registro -->
                <div id="registro" class="form-content">
                    <form method="POST" enctype="multipart/form-data">
                        <div class="foto-perfil-wrapper">
                            <div class="foto-preview" id="fotoPreview">
                                <span class="foto-preview-icon"><i class="fas fa-camera"></i></span>
                            </div>
                            <label class="foto-input-label">
                                <i class="fas fa-folder-open"></i>
                                Escolher Foto
                                <input type="file" name="foto_perfil" accept="image/*" required onchange="previewFoto(event)">
                            </label>
                            <small style="color: var(--text-tertiary); font-size: 12px;">Foto de perfil obrigatória</small>
                        </div>

                        <div class="input-group">
                            <label class="input-label">Nome Completo</label>
                            <div class="input-wrapper">
                                <input type="text" name="nome" class="form-input" placeholder="Seu nome completo" required>
                                <span class="input-icon"><i class="fas fa-user"></i></span>
                            </div>
                        </div>

                        <div class="input-group">
                            <label class="input-label">Email</label>
                            <div class="input-wrapper">
                                <input type="email" name="email" class="form-input" placeholder="seu@email.com" required>
                                <span class="input-icon"><i class="fas fa-envelope"></i></span>
                            </div>
                        </div>

                        <div class="input-group">
                            <label class="input-label">Senha</label>
                            <div class="input-wrapper">
                                <input type="password" name="senha" class="form-input" placeholder="Mínimo 6 caracteres" required minlength="6">
                                <span class="input-icon"><i class="fas fa-lock"></i></span>
                            </div>
                        </div>

                        <div class="grid-2">
                            <div class="input-group">
                                <label class="input-label">Telefone</label>
                                <div class="input-wrapper">
                                    <input type="text" name="telefone" class="form-input" placeholder="(11) 99999-9999" required>
                                    <span class="input-icon"><i class="fas fa-phone"></i></span>
                                </div>
                            </div>

                            <div class="input-group">
                                <label class="input-label">Instagram</label>
                                <div class="input-wrapper">
                                    <input type="text" name="instagram" class="form-input" placeholder="@usuario">
                                    <span class="input-icon"><i class="fab fa-instagram"></i></span>
                                </div>
                            </div>
                        </div>

                        <div class="grid-2">
                            <div class="input-group">
                                <label class="input-label">Cidade</label>
                                <div class="input-wrapper">
                                    <input type="text" name="cidade" class="form-input" placeholder="Sua cidade" required>
                                    <span class="input-icon"><i class="fas fa-city"></i></span>
                                </div>
                            </div>

                            <div class="input-group">
                                <label class="input-label">Bairro</label>
                                <div class="input-wrapper">
                                    <input type="text" name="bairro" class="form-input" placeholder="Seu bairro" required>
                                    <span class="input-icon"><i class="fas fa-map-marker-alt"></i></span>
                                </div>
                            </div>
                        </div>

                        <div class="input-group">
                            <label class="input-label">Idade</label>
                            <div class="input-wrapper">
                                <input type="number" name="idade" class="form-input" placeholder="18" required min="18" max="100">
                                <span class="input-icon"><i class="fas fa-birthday-cake"></i></span>
                            </div>
                        </div>

                        <button type="submit" name="registro" class="btn-primary">
                            <span>Criar Conta</span>
                            <span class="btn-icon"><i class="fas fa-arrow-right"></i></span>
                        </button>
                    </form>
                </div>
            </div>

            <div class="footer-text">
                Desenvolvido por <a href="#">Alerson Araújo</a><br>
                Licenciado para <strong>Espaço Taal</strong>
            </div>
        </div>
    </div>

    <script>
        function switchTab(tab) {
            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
            document.querySelectorAll('.form-content').forEach(f => f.classList.remove('active'));
            
            event.target.classList.add('active');
            document.getElementById(tab).classList.add('active');
        }

        function previewFoto(event) {
            const file = event.target.files[0];
            const preview = document.getElementById('fotoPreview');
            
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    preview.innerHTML = `<img src="${e.target.result}" alt="Preview">`;
                }
                reader.readAsDataURL(file);
            }
        }
    </script>
</body>
</html>