<?php
// mensagens.php - Visualizar Mensagens Recebidas - Versão 3.0
require_once 'config.php';
verificarLogin();

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$sucesso = '';
$erro = '';

// Buscar dados do usuário para sidebar
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();

// Processar ação de marcar como lida
if (isset($_GET['marcar_lida'])) {
    $mensagem_id = filter_input(INPUT_GET, 'marcar_lida', FILTER_SANITIZE_NUMBER_INT);

    $stmt = $pdo->prepare("
        UPDATE mensagens_destinatarios
        SET lida = 1, lida_em = NOW()
        WHERE mensagem_id = ? AND destinatario_id = ?
    ");

    if ($stmt->execute([$mensagem_id, $user_id])) {
        // Atualizar contador
        $pdo->prepare("UPDATE users SET mensagens_nao_lidas = GREATEST(mensagens_nao_lidas - 1, 0) WHERE id = ?")
            ->execute([$user_id]);

        $sucesso = "Mensagem marcada como lida!";
    }
}

// Processar ação de arquivar
if (isset($_GET['arquivar'])) {
    $mensagem_id = filter_input(INPUT_GET, 'arquivar', FILTER_SANITIZE_NUMBER_INT);

    $stmt = $pdo->prepare("
        UPDATE mensagens_destinatarios
        SET arquivada = 1
        WHERE mensagem_id = ? AND destinatario_id = ?
    ");

    if ($stmt->execute([$mensagem_id, $user_id])) {
        $sucesso = "Mensagem arquivada!";
    }
}

// Filtros
$filtro = $_GET['filtro'] ?? 'todas';
$where_filtro = "";

switch ($filtro) {
    case 'nao_lidas':
        $where_filtro = "AND md.lida = 0";
        break;
    case 'lidas':
        $where_filtro = "AND md.lida = 1";
        break;
    case 'arquivadas':
        $where_filtro = "AND md.arquivada = 1";
        break;
    default:
        $where_filtro = "AND md.arquivada = 0";
}

// Buscar mensagens recebidas
$stmt = $pdo->prepare("
    SELECT m.*, md.lida, md.lida_em, md.arquivada
    FROM mensagens m
    INNER JOIN mensagens_destinatarios md ON m.id = md.mensagem_id
    WHERE md.destinatario_id = ?
    $where_filtro
    ORDER BY m.created_at DESC
    LIMIT 100
");
$stmt->execute([$user_id]);
$mensagens = $stmt->fetchAll();

// Contar mensagens
$stmt = $pdo->prepare("
    SELECT
        COUNT(*) as total,
        SUM(CASE WHEN md.lida = 0 THEN 1 ELSE 0 END) as nao_lidas,
        SUM(CASE WHEN md.lida = 1 THEN 1 ELSE 0 END) as lidas,
        SUM(CASE WHEN md.arquivada = 1 THEN 1 ELSE 0 END) as arquivadas
    FROM mensagens_destinatarios md
    WHERE md.destinatario_id = ?
");
$stmt->execute([$user_id]);
$contadores = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Minhas Mensagens</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">
    <link rel="stylesheet" href="assets/css/sidebar.css">
    <style>
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 20px;
        }

        .page-header {
            margin-bottom: 30px;
        }

        .page-title {
            font-size: 32px;
            font-weight: 700;
            color: #FFD700;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .page-subtitle {
            color: #999999;
            font-size: 16px;
        }

        .filters-bar {
            background: #1a1a1a;
            border: 2px solid #2a2a2a;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 30px;
            display: flex;
            gap: 15px;
            flex-wrap: wrap;
        }

        .filter-btn {
            padding: 10px 20px;
            background: #0a0a0a;
            border: 2px solid #2a2a2a;
            border-radius: 10px;
            color: #999999;
            text-decoration: none;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .filter-btn:hover {
            border-color: #FFD700;
            color: #FFD700;
        }

        .filter-btn.active {
            background: linear-gradient(135deg, #FFD700 0%, #FFA500 100%);
            border-color: #FFD700;
            color: #000;
        }

        .filter-badge {
            background: rgba(0, 0, 0, 0.3);
            padding: 2px 8px;
            border-radius: 10px;
            font-size: 12px;
            font-weight: 700;
        }

        .messages-list {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }

        .message-card {
            background: #1a1a1a;
            border: 2px solid #2a2a2a;
            border-radius: 15px;
            padding: 20px;
            transition: all 0.3s;
            position: relative;
        }

        .message-card.unread {
            border-left: 4px solid #FFD700;
            background: rgba(255, 215, 0, 0.05);
        }

        .message-card:hover {
            border-color: #FFD700;
            transform: translateX(5px);
        }

        .message-top {
            display: flex;
            justify-content: space-between;
            align-items: start;
            margin-bottom: 15px;
        }

        .message-title {
            font-size: 18px;
            font-weight: 700;
            color: #FFD700;
            margin-bottom: 8px;
        }

        .message-from {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 13px;
            color: #999999;
            margin-bottom: 5px;
        }

        .message-date {
            font-size: 13px;
            color: #666666;
        }

        .message-content {
            color: #CCCCCC;
            font-size: 14px;
            line-height: 1.6;
            margin-bottom: 15px;
        }

        .message-actions {
            display: flex;
            gap: 10px;
            padding-top: 15px;
            border-top: 1px solid #2a2a2a;
        }

        .action-btn {
            padding: 8px 16px;
            background: #0a0a0a;
            border: 2px solid #2a2a2a;
            border-radius: 8px;
            color: #999999;
            text-decoration: none;
            font-size: 13px;
            font-weight: 600;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }

        .action-btn:hover {
            border-color: #FFD700;
            color: #FFD700;
        }

        .action-btn.primary {
            background: linear-gradient(135deg, #FFD700 0%, #FFA500 100%);
            border-color: #FFD700;
            color: #000;
        }

        .priority-badge {
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 700;
            text-transform: uppercase;
        }

        .priority-badge.baixa {
            background: rgba(153, 153, 153, 0.2);
            color: #999999;
        }

        .priority-badge.normal {
            background: rgba(255, 215, 0, 0.2);
            color: #FFD700;
        }

        .priority-badge.alta {
            background: rgba(255, 165, 0, 0.2);
            color: #FFA500;
        }

        .priority-badge.urgente {
            background: rgba(220, 53, 69, 0.2);
            color: #dc3545;
            animation: pulse 2s ease-in-out infinite;
        }

        @keyframes pulse {
            0%, 100% {
                opacity: 1;
            }
            50% {
                opacity: 0.7;
            }
        }

        .unread-indicator {
            width: 12px;
            height: 12px;
            background: #FFD700;
            border-radius: 50%;
            position: absolute;
            top: 20px;
            right: 20px;
            animation: pulse-dot 2s ease-in-out infinite;
        }

        @keyframes pulse-dot {
            0%, 100% {
                transform: scale(1);
                box-shadow: 0 0 0 0 rgba(255, 215, 0, 0.7);
            }
            50% {
                transform: scale(1.2);
                box-shadow: 0 0 0 10px rgba(255, 215, 0, 0);
            }
        }

        @media (max-width: 768px) {
            .filters-bar {
                flex-direction: column;
            }

            .filter-btn {
                width: 100%;
                justify-content: center;
            }

            .message-top {
                flex-direction: column;
                gap: 10px;
            }

            .message-actions {
                flex-wrap: wrap;
            }
        }
    </style>
</head>
<body>
    <?php include 'assets/sidebar.php'; ?>

    <div class="container">
        <div class="page-header">
            <h1 class="page-title">
                <i class="fas fa-envelope"></i>
                Minhas Mensagens
            </h1>
            <p class="page-subtitle">Avisos e mensagens do sistema</p>
        </div>

        <?php if ($sucesso): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?= htmlspecialchars($sucesso) ?>
            </div>
        <?php endif; ?>

        <!-- Filtros -->
        <div class="filters-bar">
            <a href="?filtro=todas" class="filter-btn <?= $filtro === 'todas' ? 'active' : '' ?>">
                <i class="fas fa-inbox"></i>
                Todas
                <span class="filter-badge"><?= $contadores['total'] - $contadores['arquivadas'] ?></span>
            </a>

            <a href="?filtro=nao_lidas" class="filter-btn <?= $filtro === 'nao_lidas' ? 'active' : '' ?>">
                <i class="fas fa-envelope"></i>
                Não Lidas
                <span class="filter-badge"><?= $contadores['nao_lidas'] ?></span>
            </a>

            <a href="?filtro=lidas" class="filter-btn <?= $filtro === 'lidas' ? 'active' : '' ?>">
                <i class="fas fa-envelope-open"></i>
                Lidas
                <span class="filter-badge"><?= $contadores['lidas'] ?></span>
            </a>

            <a href="?filtro=arquivadas" class="filter-btn <?= $filtro === 'arquivadas' ? 'active' : '' ?>">
                <i class="fas fa-archive"></i>
                Arquivadas
                <span class="filter-badge"><?= $contadores['arquivadas'] ?></span>
            </a>
        </div>

        <!-- Lista de Mensagens -->
        <div class="messages-list">
            <?php if (empty($mensagens)): ?>
                <div class="empty-state">
                    <i class="fas fa-inbox"></i>
                    <h3>Nenhuma mensagem encontrada</h3>
                    <p>Você não tem mensagens nesta categoria</p>
                </div>
            <?php else: ?>
                <?php foreach ($mensagens as $msg): ?>
                    <div class="message-card <?= !$msg['lida'] ? 'unread' : '' ?>">
                        <?php if (!$msg['lida']): ?>
                            <div class="unread-indicator"></div>
                        <?php endif; ?>

                        <div class="message-top">
                            <div>
                                <div class="message-title">
                                    <?= htmlspecialchars($msg['assunto']) ?>
                                </div>
                                <div class="message-from">
                                    <i class="fas fa-user-shield"></i>
                                    <span><?= htmlspecialchars($msg['remetente_nome']) ?></span>
                                    <span>•</span>
                                    <span><?= ucfirst($msg['remetente_role']) ?></span>
                                </div>
                                <div class="message-date">
                                    <i class="fas fa-clock"></i>
                                    <?= date('d/m/Y \à\s H:i', strtotime($msg['created_at'])) ?>
                                    <?php if ($msg['lida']): ?>
                                        <span style="color: #666666;">
                                            • Lida em <?= date('d/m/Y H:i', strtotime($msg['lida_em'])) ?>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <span class="priority-badge <?= $msg['prioridade'] ?>">
                                <?= strtoupper($msg['prioridade']) ?>
                            </span>
                        </div>

                        <div class="message-content">
                            <?= nl2br(htmlspecialchars($msg['mensagem'])) ?>
                        </div>

                        <div class="message-actions">
                            <?php if (!$msg['lida']): ?>
                                <a href="?marcar_lida=<?= $msg['id'] ?>&filtro=<?= $filtro ?>"
                                   class="action-btn primary">
                                    <i class="fas fa-check"></i>
                                    Marcar como Lida
                                </a>
                            <?php endif; ?>

                            <?php if (!$msg['arquivada']): ?>
                                <a href="?arquivar=<?= $msg['id'] ?>&filtro=<?= $filtro ?>"
                                   class="action-btn"
                                   onclick="return confirm('Deseja arquivar esta mensagem?')">
                                    <i class="fas fa-archive"></i>
                                    Arquivar
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    </div><!-- /.main-content -->
    <script src="assets/js/sidebar.js"></script>
</body>
</html>
