<?php
// meu_perfil.php - Edição de Perfil Pessoal para todos os usuários
require_once 'config.php';
verificarLogin();

$user_id = $_SESSION['user_id'];
$sucesso = '';
$erro = '';

// Buscar dados do usuário
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();

// Processar alteração de dados
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Alterar senha
    if (isset($_POST['alterar_senha'])) {
        $senha_atual = $_POST['senha_atual'];
        $senha_nova = $_POST['senha_nova'];
        $senha_confirmar = $_POST['senha_confirmar'];

        // Verificar senha atual
        if (password_verify($senha_atual, $usuario['senha'])) {
            if ($senha_nova === $senha_confirmar) {
                if (strlen($senha_nova) >= 6) {
                    $senha_hash = password_hash($senha_nova, PASSWORD_DEFAULT);
                    $stmt = $pdo->prepare("UPDATE users SET senha = ? WHERE id = ?");
                    if ($stmt->execute([$senha_hash, $user_id])) {
                        $sucesso = 'Senha alterada com sucesso!';
                    } else {
                        $erro = 'Erro ao alterar senha.';
                    }
                } else {
                    $erro = 'A nova senha deve ter no mínimo 6 caracteres.';
                }
            } else {
                $erro = 'As senhas não conferem.';
            }
        } else {
            $erro = 'Senha atual incorreta.';
        }
    }

    // Alterar dados pessoais
    if (isset($_POST['alterar_dados'])) {
        $nome = trim($_POST['nome']);
        $email = trim($_POST['email']);
        $telefone = trim($_POST['telefone']);
        $instagram = trim($_POST['instagram']);

        if (empty($nome)) {
            $erro = 'Nome é obrigatório.';
        } elseif (empty($email)) {
            $erro = 'Email é obrigatório.';
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $erro = 'Email inválido.';
        } else {
            // Verificar se email já está em uso por outro usuário
            $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ? AND id != ?");
            $stmt->execute([$email, $user_id]);
            if ($stmt->fetch()) {
                $erro = 'Este email já está sendo usado por outro usuário.';
            } else {
                $stmt = $pdo->prepare("UPDATE users SET nome = ?, email = ?, telefone = ?, instagram = ? WHERE id = ?");
                if ($stmt->execute([$nome, $email, $telefone, $instagram, $user_id])) {
                    $sucesso = 'Dados atualizados com sucesso!';
                    // Recarregar dados
                    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
                    $stmt->execute([$user_id]);
                    $usuario = $stmt->fetch();
                } else {
                    $erro = 'Erro ao atualizar dados.';
                }
            }
        }
    }

    // Upload de foto de perfil
    if (isset($_FILES['foto_perfil']) && $_FILES['foto_perfil']['error'] == 0) {
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];
        $filename = $_FILES['foto_perfil']['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));

        if (in_array($ext, $allowed)) {
            // Verificar tamanho (max 5MB)
            if ($_FILES['foto_perfil']['size'] <= 5 * 1024 * 1024) {
                $novo_nome = 'perfil_' . $user_id . '_' . time() . '.' . $ext;
                $destino = 'uploads/perfil/' . $novo_nome;

                if (!is_dir('uploads/perfil')) {
                    mkdir('uploads/perfil', 0777, true);
                }

                if (move_uploaded_file($_FILES['foto_perfil']['tmp_name'], $destino)) {
                    // Deletar foto antiga se existir
                    if (!empty($usuario['foto_perfil']) && file_exists($usuario['foto_perfil'])) {
                        unlink($usuario['foto_perfil']);
                    }

                    $stmt = $pdo->prepare("UPDATE users SET foto_perfil = ? WHERE id = ?");
                    if ($stmt->execute([$destino, $user_id])) {
                        $sucesso = 'Foto de perfil atualizada com sucesso!';
                        // Recarregar dados
                        $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
                        $stmt->execute([$user_id]);
                        $usuario = $stmt->fetch();
                    }
                } else {
                    $erro = 'Erro ao fazer upload da foto.';
                }
            } else {
                $erro = 'A foto deve ter no máximo 5MB.';
            }
        } else {
            $erro = 'Formato de imagem não permitido. Use JPG, PNG ou GIF.';
        }
    }
}

// Definir foto padrão se não existir
$foto_perfil = !empty($usuario['foto_perfil']) && file_exists($usuario['foto_perfil'])
    ? $usuario['foto_perfil']
    : 'assets/default-avatar.png';
?>
<!DOCTYPE html>
<html lang="pt-BR" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Meu Perfil - Sistema Promoters</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">
    <link rel="stylesheet" href="assets/css/sidebar.css">
    <style>
        .perfil-container {
            max-width: 900px;
            margin: 40px auto;
            padding: 0 20px;
        }

        .perfil-header {
            text-align: center;
            margin-bottom: 40px;
        }

        .perfil-header h1 {
            font-size: 32px;
            color: var(--color-gold);
            margin-bottom: 10px;
        }

        .foto-section {
            text-align: center;
            margin-bottom: 30px;
        }

        .foto-preview {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            object-fit: cover;
            border: 4px solid var(--color-gold);
            margin-bottom: 20px;
            box-shadow: 0 4px 20px rgba(255, 215, 0, 0.3);
        }

        .foto-upload-btn {
            position: relative;
            display: inline-block;
        }

        .foto-upload-btn input[type="file"] {
            position: absolute;
            opacity: 0;
            width: 100%;
            height: 100%;
            cursor: pointer;
        }

        .foto-upload-btn label {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            padding: 12px 24px;
            background: var(--color-gold);
            color: #000;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
            transition: all 0.3s;
        }

        .foto-upload-btn:hover label {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 215, 0, 0.4);
        }

        .sections-grid {
            display: grid;
            gap: 30px;
        }

        .section-card {
            background: var(--bg-card);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 30px;
        }

        .section-title {
            font-size: 22px;
            color: var(--color-gold);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 12px;
            padding-bottom: 15px;
            border-bottom: 2px solid var(--border-color);
        }

        .form-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
        }

        .badge-role {
            display: inline-block;
            padding: 6px 14px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 600;
            margin-left: 10px;
        }

        .badge-admin {
            background: rgba(255, 215, 0, 0.2);
            color: var(--color-gold);
            border: 1px solid var(--color-gold);
        }

        .badge-promoter {
            background: rgba(33, 150, 243, 0.2);
            color: #2196F3;
            border: 1px solid #2196F3;
        }

        .badge-produtor {
            background: rgba(156, 39, 176, 0.2);
            color: #9C27B0;
            border: 1px solid #9C27B0;
        }

        @media (max-width: 768px) {
            .perfil-container {
                margin: 20px auto;
            }

            .form-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <?php include 'assets/sidebar.php'; ?>

    <div class="perfil-container">
        <div class="perfil-header">
            <h1><i class="fas fa-user-circle"></i> Meu Perfil</h1>
            <p style="color: var(--text-secondary);">
                Gerencie suas informações pessoais
                <span class="badge-role badge-<?= $usuario['role'] === 'admin' ? 'admin' : ($usuario['role'] === 'user' ? 'promoter' : 'produtor') ?>">
                    <?= $usuario['role'] === 'admin' ? 'Administrador' : ($usuario['role'] === 'user' ? 'Promoter' : 'Produtor') ?>
                </span>
            </p>
        </div>

        <?php if ($sucesso): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?= htmlspecialchars($sucesso) ?>
            </div>
        <?php endif; ?>

        <?php if ($erro): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i>
                <?= htmlspecialchars($erro) ?>
            </div>
        <?php endif; ?>

        <!-- Foto de Perfil -->
        <div class="section-card foto-section">
            <h2 class="section-title">
                <i class="fas fa-camera"></i>
                Foto de Perfil
            </h2>

            <img src="<?= htmlspecialchars($foto_perfil) ?>"
                 alt="Foto de Perfil"
                 class="foto-preview"
                 id="foto-preview"
                 onerror="this.src='assets/default-avatar.png'">

            <form method="POST" enctype="multipart/form-data">
                <div class="foto-upload-btn">
                    <label for="foto_perfil">
                        <i class="fas fa-upload"></i>
                        Alterar Foto
                    </label>
                    <input type="file"
                           id="foto_perfil"
                           name="foto_perfil"
                           accept="image/*"
                           onchange="previewFoto(event); this.form.submit();">
                </div>
            </form>
            <p style="color: var(--text-secondary); font-size: 13px; margin-top: 10px;">
                Formatos aceitos: JPG, PNG, GIF. Tamanho máximo: 5MB
            </p>
        </div>

        <!-- Dados Pessoais -->
        <div class="section-card">
            <h2 class="section-title">
                <i class="fas fa-id-card"></i>
                Dados Pessoais
            </h2>

            <form method="POST">
                <div class="form-grid">
                    <div class="form-group">
                        <label><i class="fas fa-user"></i> Nome Completo</label>
                        <input type="text"
                               name="nome"
                               value="<?= htmlspecialchars($usuario['nome']) ?>"
                               required
                               class="form-input">
                    </div>

                    <div class="form-group">
                        <label><i class="fas fa-envelope"></i> Email</label>
                        <input type="email"
                               name="email"
                               value="<?= htmlspecialchars($usuario['email']) ?>"
                               required
                               class="form-input">
                    </div>

                    <div class="form-group">
                        <label><i class="fas fa-phone"></i> Telefone</label>
                        <input type="text"
                               name="telefone"
                               value="<?= htmlspecialchars($usuario['telefone'] ?? '') ?>"
                               placeholder="(11) 99999-9999"
                               class="form-input">
                    </div>

                    <div class="form-group">
                        <label><i class="fab fa-instagram"></i> Instagram</label>
                        <input type="text"
                               name="instagram"
                               value="<?= htmlspecialchars($usuario['instagram'] ?? '') ?>"
                               placeholder="@usuario"
                               class="form-input">
                    </div>
                </div>

                <button type="submit" name="alterar_dados" class="btn btn-primary" style="margin-top: 20px;">
                    <i class="fas fa-save"></i>
                    Salvar Dados
                </button>
            </form>
        </div>

        <!-- Alterar Senha -->
        <div class="section-card">
            <h2 class="section-title">
                <i class="fas fa-lock"></i>
                Alterar Senha
            </h2>

            <form method="POST">
                <div class="form-grid">
                    <div class="form-group">
                        <label><i class="fas fa-key"></i> Senha Atual</label>
                        <input type="password"
                               name="senha_atual"
                               required
                               class="form-input"
                               placeholder="Digite sua senha atual">
                    </div>

                    <div class="form-group">
                        <label><i class="fas fa-lock"></i> Nova Senha</label>
                        <input type="password"
                               name="senha_nova"
                               required
                               minlength="6"
                               class="form-input"
                               placeholder="Mínimo 6 caracteres">
                    </div>

                    <div class="form-group">
                        <label><i class="fas fa-lock"></i> Confirmar Nova Senha</label>
                        <input type="password"
                               name="senha_confirmar"
                               required
                               minlength="6"
                               class="form-input"
                               placeholder="Digite novamente">
                    </div>
                </div>

                <button type="submit" name="alterar_senha" class="btn btn-primary" style="margin-top: 20px;">
                    <i class="fas fa-shield-alt"></i>
                    Alterar Senha
                </button>
            </form>
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <a href="dashboard.php" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i>
                Voltar ao Dashboard
            </a>
        </div>
    </div>

    <script>
        function previewFoto(event) {
            const file = event.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    document.getElementById('foto-preview').src = e.target.result;
                }
                reader.readAsDataURL(file);
            }
        }
    </script>
    </div><!-- /.main-content -->
    <script src="assets/js/sidebar.js"></script>
</body>
</html>
