-- migration_aniversarios.sql
-- Sistema de gerenciamento de aniversários com envio automático
-- IMPORTANTE: data_nascimento armazena apenas DIA e MÊS (formato: --MM-DD)

-- Tabela para histórico de envios de aniversários
CREATE TABLE IF NOT EXISTS aniversarios_enviados (
    id INT AUTO_INCREMENT PRIMARY KEY,
    convidado_id INT NOT NULL,
    ano INT NOT NULL,
    tipo_envio ENUM('email', 'whatsapp', 'ambos') NOT NULL,
    enviado_por INT NOT NULL COMMENT 'ID do admin que enviou',
    mensagem_enviada TEXT,
    enviado_automatico TINYINT(1) DEFAULT 0 COMMENT '1 se foi envio automático, 0 se manual',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (convidado_id) REFERENCES convidados(id) ON DELETE CASCADE,
    FOREIGN KEY (enviado_por) REFERENCES users(id) ON DELETE CASCADE,
    UNIQUE KEY unique_envio_ano (convidado_id, ano),
    INDEX idx_ano (ano),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela para configurações de aniversários
CREATE TABLE IF NOT EXISTS configuracoes_aniversarios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mensagem_padrao_assunto VARCHAR(500) DEFAULT 'Parabéns {nome} pelo seu dia!' COMMENT 'Assunto do email com campos dinâmicos',
    mensagem_padrao_corpo TEXT COMMENT 'Corpo da mensagem com campos dinâmicos: {nome}, {sobrenome}, {nome_completo}',
    imagem_anexo VARCHAR(500) DEFAULT NULL COMMENT 'Caminho da imagem para anexar no email',
    envio_automatico_ativo TINYINT(1) DEFAULT 1 COMMENT 'Ativar/desativar envio automático diário',
    horario_envio_automatico TIME DEFAULT '09:00:00' COMMENT 'Horário do envio automático',
    mensagem_whatsapp_padrao TEXT COMMENT 'Mensagem padrão para WhatsApp',
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Inserir configuração padrão
INSERT INTO configuracoes_aniversarios (
    mensagem_padrao_assunto,
    mensagem_padrao_corpo,
    mensagem_whatsapp_padrao
) VALUES (
    'Parabéns {nome} pelo seu dia! 🎉',
    'Olá {nome_completo},\n\nParabéns pelo seu aniversário! 🎂🎉\n\nDesejamos um dia incrível repleto de alegrias, amor e muitas realizações!\n\nQue este novo ciclo seja cheio de conquistas e momentos especiais.\n\nUm grande abraço da nossa equipe!',
    'Olá {nome}! 🎉\n\nParabéns pelo seu aniversário! 🎂\n\nDesejamos um dia incrível cheio de alegrias!\n\nGrande abraço! 💛'
) ON DUPLICATE KEY UPDATE id=id;

-- Adicionar índice na coluna data_nascimento da tabela convidados
-- Versão compatível com MySQL 5.x (sem IF NOT EXISTS)
ALTER TABLE convidados ADD INDEX idx_data_nascimento (data_nascimento);
