-- migration_checkin_global.sql
-- Adicionar campo para controlar qual evento está aberto para check-in GLOBALMENTE
-- Isso permite que múltiplos admins façam check-in no mesmo evento simultaneamente

-- Adicionar campo checkin_aberto na tabela eventos
ALTER TABLE eventos
ADD COLUMN checkin_aberto TINYINT(1) DEFAULT 0
COMMENT 'Indica se o evento está aberto para check-in (0=fechado, 1=aberto)';

-- Criar índice para performance
CREATE INDEX idx_checkin_aberto ON eventos(checkin_aberto);

-- Fechar todos os eventos (estado inicial seguro)
UPDATE eventos SET checkin_aberto = 0;
