-- Migration: Corrigir bug de saque parcial
-- Descrição: Adiciona tabela para rastrear quais comissões foram usadas em cada saque
-- Data: 2025-12-09

-- Criar tabela para relacionar saques com comissões
CREATE TABLE IF NOT EXISTS saque_comissoes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    saque_id INT NOT NULL,
    comissao_id INT NOT NULL,
    valor_usado DECIMAL(10,2) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (saque_id) REFERENCES saques(id) ON DELETE CASCADE,
    FOREIGN KEY (comissao_id) REFERENCES comissoes(id) ON DELETE CASCADE,
    INDEX idx_saque (saque_id),
    INDEX idx_comissao (comissao_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Comentário explicativo
-- Esta tabela permite rastrear exatamente quais comissões foram usadas em cada saque
-- e quanto de cada comissão foi utilizado, permitindo saques parciais corretos
