-- Migration: Adicionar Configurações de Email
-- Data: 2025-11-18
-- Descrição: Adiciona campos para configurar email de envio nativo (PHP mail())

-- Adicionar colunas de configuração de email na tabela configuracoes
ALTER TABLE configuracoes
ADD COLUMN IF NOT EXISTS email_remetente VARCHAR(255) DEFAULT 'noreply@seudominio.com.br',
ADD COLUMN IF NOT EXISTS email_nome_remetente VARCHAR(255) DEFAULT 'Sistema Promotaal';

-- Atualizar com valores padrão se já existe registro
UPDATE configuracoes
SET email_remetente = 'noreply@seudominio.com.br',
    email_nome_remetente = 'Sistema Promotaal'
WHERE id = 1
AND (email_remetente IS NULL OR email_remetente = '');

-- Verificar se foi criado corretamente
SELECT 'Migração concluída com sucesso!' as status;
SELECT * FROM configuracoes WHERE id = 1;
