<?php
// notificacoes.php - Central de Notificações - Versão 3.0
require_once 'config.php';
verificarLogin();

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$sucesso = '';

// Buscar dados do usuário para sidebar
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();

// Processar ação de marcar como lida
if (isset($_GET['marcar_lida'])) {
    $notificacao_id = filter_input(INPUT_GET, 'marcar_lida', FILTER_SANITIZE_NUMBER_INT);

    $stmt = $pdo->prepare("
        UPDATE notificacoes
        SET lida = 1, lida_em = NOW()
        WHERE id = ? AND user_id = ?
    ");

    if ($stmt->execute([$notificacao_id, $user_id])) {
        // Atualizar contador
        $pdo->prepare("UPDATE users SET notificacoes_nao_lidas = GREATEST(notificacoes_nao_lidas - 1, 0) WHERE id = ?")
            ->execute([$user_id]);

        $sucesso = "Notificação marcada como lida!";
    }
}

// Marcar todas como lidas
if (isset($_POST['marcar_todas_lidas'])) {
    $categoria = $_POST['categoria'] ?? null;

    if ($categoria) {
        $stmt = $pdo->prepare("
            UPDATE notificacoes
            SET lida = 1, lida_em = NOW()
            WHERE user_id = ? AND categoria = ? AND lida = 0
        ");
        $stmt->execute([$user_id, $categoria]);
    } else {
        $stmt = $pdo->prepare("
            UPDATE notificacoes
            SET lida = 1, lida_em = NOW()
            WHERE user_id = ? AND lida = 0
        ");
        $stmt->execute([$user_id]);
    }

    // Recalcular contador
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM notificacoes WHERE user_id = ? AND lida = 0");
    $stmt->execute([$user_id]);
    $nao_lidas = $stmt->fetchColumn();

    $pdo->prepare("UPDATE users SET notificacoes_nao_lidas = ? WHERE id = ?")
        ->execute([$nao_lidas, $user_id]);

    $sucesso = "Todas as notificações foram marcadas como lidas!";
}

// Filtro de categoria
$categoria_filtro = $_GET['categoria'] ?? 'todas';
$where_categoria = "";

if ($categoria_filtro !== 'todas') {
    $where_categoria = "AND categoria = " . $pdo->quote($categoria_filtro);
}

// Buscar notificações
$stmt = $pdo->prepare("
    SELECT *
    FROM notificacoes
    WHERE user_id = ?
    $where_categoria
    ORDER BY lida ASC, created_at DESC
    LIMIT 100
");
$stmt->execute([$user_id]);
$notificacoes = $stmt->fetchAll();

// Contar notificações por categoria
$stmt = $pdo->prepare("
    SELECT
        categoria,
        COUNT(*) as total,
        SUM(CASE WHEN lida = 0 THEN 1 ELSE 0 END) as nao_lidas
    FROM notificacoes
    WHERE user_id = ?
    GROUP BY categoria
");
$stmt->execute([$user_id]);
$contadores_categoria = [];
while ($row = $stmt->fetch()) {
    $contadores_categoria[$row['categoria']] = $row;
}

// Total geral
$stmt = $pdo->prepare("
    SELECT
        COUNT(*) as total,
        SUM(CASE WHEN lida = 0 THEN 1 ELSE 0 END) as nao_lidas
    FROM notificacoes
    WHERE user_id = ?
");
$stmt->execute([$user_id]);
$total_geral = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notificações</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">
    <link rel="stylesheet" href="assets/css/sidebar.css">
    <style>
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 20px;
        }

        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: start;
            margin-bottom: 30px;
        }

        .page-title {
            font-size: 32px;
            font-weight: 700;
            color: #FFD700;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .page-subtitle {
            color: #999999;
            font-size: 16px;
        }

        .header-actions {
            display: flex;
            gap: 10px;
        }

        .btn-mark-all {
            padding: 10px 20px;
            background: linear-gradient(135deg, #FFD700 0%, #FFA500 100%);
            color: #000;
            border: none;
            border-radius: 10px;
            font-size: 14px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-mark-all:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 215, 0, 0.4);
        }

        .categories-bar {
            background: #1a1a1a;
            border: 2px solid #2a2a2a;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 30px;
        }

        .categories-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }

        .category-card {
            padding: 20px;
            background: #0a0a0a;
            border: 2px solid #2a2a2a;
            border-radius: 12px;
            text-decoration: none;
            transition: all 0.3s;
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        .category-card:hover {
            border-color: #FFD700;
            transform: translateY(-3px);
        }

        .category-card.active {
            background: rgba(255, 215, 0, 0.1);
            border-color: #FFD700;
        }

        .category-icon {
            font-size: 32px;
            margin-bottom: 10px;
        }

        .category-icon.financeiro { color: #00C851; }
        .category-icon.eventos { color: #FFD700; }
        .category-icon.geral { color: #17a2b8; }
        .category-icon.mensagens { color: #FFA500; }

        .category-name {
            font-size: 16px;
            font-weight: 700;
            color: #FFFFFF;
        }

        .category-count {
            font-size: 13px;
            color: #999999;
        }

        .category-badge {
            display: inline-block;
            padding: 4px 10px;
            background: linear-gradient(135deg, #FFD700 0%, #FFA500 100%);
            color: #000;
            border-radius: 10px;
            font-size: 12px;
            font-weight: 700;
            margin-top: 5px;
        }

        .notifications-list {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .notification-item {
            background: #1a1a1a;
            border: 2px solid #2a2a2a;
            border-radius: 12px;
            padding: 18px;
            transition: all 0.3s;
            display: flex;
            gap: 15px;
            align-items: start;
        }

        .notification-item.unread {
            border-left: 4px solid #FFD700;
            background: rgba(255, 215, 0, 0.05);
        }

        .notification-item:hover {
            border-color: #FFD700;
            transform: translateX(5px);
        }

        .notification-icon {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            flex-shrink: 0;
        }

        .notification-icon.financeiro {
            background: rgba(0, 200, 81, 0.2);
            color: #00C851;
        }

        .notification-icon.eventos {
            background: rgba(255, 215, 0, 0.2);
            color: #FFD700;
        }

        .notification-icon.geral {
            background: rgba(23, 162, 184, 0.2);
            color: #17a2b8;
        }

        .notification-icon.mensagens {
            background: rgba(255, 165, 0, 0.2);
            color: #FFA500;
        }

        .notification-content {
            flex: 1;
        }

        .notification-title {
            font-size: 16px;
            font-weight: 700;
            color: #FFFFFF;
            margin-bottom: 5px;
        }

        .notification-message {
            font-size: 14px;
            color: #CCCCCC;
            line-height: 1.5;
            margin-bottom: 8px;
        }

        .notification-meta {
            display: flex;
            gap: 15px;
            font-size: 12px;
            color: #666666;
        }

        .notification-actions {
            display: flex;
            gap: 8px;
            flex-shrink: 0;
        }

        .action-icon {
            width: 36px;
            height: 36px;
            border-radius: 8px;
            background: #0a0a0a;
            border: 2px solid #2a2a2a;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s;
            color: #999999;
            text-decoration: none;
        }

        .action-icon:hover {
            border-color: #FFD700;
            color: #FFD700;
        }

        .unread-dot {
            width: 10px;
            height: 10px;
            background: #FFD700;
            border-radius: 50%;
            animation: pulse-dot 2s ease-in-out infinite;
        }

        @keyframes pulse-dot {
            0%, 100% {
                transform: scale(1);
                opacity: 1;
            }
            50% {
                transform: scale(1.3);
                opacity: 0.7;
            }
        }

        @media (max-width: 768px) {
            .page-header {
                flex-direction: column;
                gap: 20px;
            }

            .categories-grid {
                grid-template-columns: 1fr;
            }

            .notification-item {
                flex-direction: column;
            }

            .notification-actions {
                width: 100%;
                justify-content: space-between;
            }
        }
    </style>
</head>
<body>
    <?php include 'assets/sidebar.php'; ?>

    <div class="container">
        <div class="page-header">
            <div>
                <h1 class="page-title">
                    <i class="fas fa-bell"></i>
                    Central de Notificações
                </h1>
                <p class="page-subtitle">
                    <?= $total_geral['nao_lidas'] ?> notificação(ões) não lida(s) de <?= $total_geral['total'] ?> total
                </p>
            </div>
            <div class="header-actions">
                <?php if ($total_geral['nao_lidas'] > 0): ?>
                    <form method="POST" style="display: inline;">
                        <input type="hidden" name="categoria" value="<?= $categoria_filtro !== 'todas' ? $categoria_filtro : '' ?>">
                        <button type="submit" name="marcar_todas_lidas" class="btn-mark-all">
                            <i class="fas fa-check-double"></i>
                            Marcar Todas como Lidas
                        </button>
                    </form>
                <?php endif; ?>
            </div>
        </div>

        <?php if ($sucesso): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?= htmlspecialchars($sucesso) ?>
            </div>
        <?php endif; ?>

        <!-- Categorias -->
        <div class="categories-bar">
            <div class="categories-grid">
                <a href="?categoria=todas" class="category-card <?= $categoria_filtro === 'todas' ? 'active' : '' ?>">
                    <i class="fas fa-bell category-icon" style="color: #FFD700;"></i>
                    <div class="category-name">Todas</div>
                    <div class="category-count"><?= $total_geral['total'] ?> notificações</div>
                    <?php if ($total_geral['nao_lidas'] > 0): ?>
                        <span class="category-badge"><?= $total_geral['nao_lidas'] ?> novas</span>
                    <?php endif; ?>
                </a>

                <a href="?categoria=financeiro" class="category-card <?= $categoria_filtro === 'financeiro' ? 'active' : '' ?>">
                    <i class="fas fa-dollar-sign category-icon financeiro"></i>
                    <div class="category-name">Financeiro</div>
                    <div class="category-count">
                        <?= $contadores_categoria['financeiro']['total'] ?? 0 ?> notificações
                    </div>
                    <?php if (($contadores_categoria['financeiro']['nao_lidas'] ?? 0) > 0): ?>
                        <span class="category-badge"><?= $contadores_categoria['financeiro']['nao_lidas'] ?> novas</span>
                    <?php endif; ?>
                </a>

                <a href="?categoria=eventos" class="category-card <?= $categoria_filtro === 'eventos' ? 'active' : '' ?>">
                    <i class="fas fa-calendar-alt category-icon eventos"></i>
                    <div class="category-name">Eventos</div>
                    <div class="category-count">
                        <?= $contadores_categoria['eventos']['total'] ?? 0 ?> notificações
                    </div>
                    <?php if (($contadores_categoria['eventos']['nao_lidas'] ?? 0) > 0): ?>
                        <span class="category-badge"><?= $contadores_categoria['eventos']['nao_lidas'] ?> novas</span>
                    <?php endif; ?>
                </a>

                <a href="?categoria=geral" class="category-card <?= $categoria_filtro === 'geral' ? 'active' : '' ?>">
                    <i class="fas fa-info-circle category-icon geral"></i>
                    <div class="category-name">Geral</div>
                    <div class="category-count">
                        <?= $contadores_categoria['geral']['total'] ?? 0 ?> notificações
                    </div>
                    <?php if (($contadores_categoria['geral']['nao_lidas'] ?? 0) > 0): ?>
                        <span class="category-badge"><?= $contadores_categoria['geral']['nao_lidas'] ?> novas</span>
                    <?php endif; ?>
                </a>
            </div>
        </div>

        <!-- Lista de Notificações -->
        <div class="notifications-list">
            <?php if (empty($notificacoes)): ?>
                <div class="empty-state">
                    <i class="fas fa-bell-slash"></i>
                    <h3>Nenhuma notificação encontrada</h3>
                    <p>Você está em dia com todas as notificações!</p>
                </div>
            <?php else: ?>
                <?php foreach ($notificacoes as $notif): ?>
                    <div class="notification-item <?= !$notif['lida'] ? 'unread' : '' ?>">
                        <div class="notification-icon <?= $notif['categoria'] ?>">
                            <i class="<?= $notif['icon'] ?? 'fas fa-bell' ?>"></i>
                        </div>

                        <div class="notification-content">
                            <div class="notification-title">
                                <?= htmlspecialchars($notif['titulo']) ?>
                            </div>
                            <div class="notification-message">
                                <?= htmlspecialchars($notif['mensagem']) ?>
                            </div>
                            <div class="notification-meta">
                                <span>
                                    <i class="fas fa-clock"></i>
                                    <?= date('d/m/Y H:i', strtotime($notif['created_at'])) ?>
                                </span>
                                <?php if ($notif['lida']): ?>
                                    <span>
                                        <i class="fas fa-check"></i>
                                        Lida em <?= date('d/m/Y H:i', strtotime($notif['lida_em'])) ?>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="notification-actions">
                            <?php if (!$notif['lida']): ?>
                                <div class="unread-dot"></div>
                                <a href="?marcar_lida=<?= $notif['id'] ?>&categoria=<?= $categoria_filtro ?>"
                                   class="action-icon" title="Marcar como lida">
                                    <i class="fas fa-check"></i>
                                </a>
                            <?php endif; ?>

                            <?php if ($notif['link']): ?>
                                <a href="<?= htmlspecialchars($notif['link']) ?>"
                                   class="action-icon" title="Ver detalhes">
                                    <i class="fas fa-external-link-alt"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    </div><!-- /.main-content -->
    <script src="assets/js/sidebar.js"></script>
</body>
</html>
