<?php
// produtor_eventos.php - Página de eventos para produtores
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

require_once 'config.php';
verificarLogin();

// Verificar se é produtor
if ($_SESSION['role'] !== 'produtor') {
    header('Location: dashboard.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Buscar eventos associados ao produtor
$stmt = $pdo->prepare("
    SELECT e.*, pe.link_exclusivo, pe.id as associacao_id,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = ? AND c.evento_id = e.id) as meus_convidados,
    (SELECT COUNT(*) FROM convidados c WHERE c.promoter_id = ? AND c.evento_id = e.id AND c.checkin = 1) as meus_checkins,
    (SELECT COUNT(*) FROM evento_arquivos ea WHERE ea.evento_id = e.id) as total_arquivos
    FROM eventos e
    INNER JOIN produtor_eventos pe ON e.id = pe.evento_id
    WHERE pe.user_id = ?
    ORDER BY e.data ASC
");
$stmt->execute([$user_id, $user_id, $user_id]);
$meus_eventos = $stmt->fetchAll();

// Buscar dados do usuário para sidebar
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$usuario = $stmt->fetch();
?>
<!DOCTYPE html>
<html lang="pt-BR" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">

    <title>Meus Eventos - Produtor</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/dashboard-style.css">
    <link rel="stylesheet" href="assets/css/sidebar.css">

    <style>
        .eventos-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 25px;
        }

        .evento-card {
            background: var(--bg-card);
            border: 2px solid var(--border-color);
            border-radius: 15px;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .evento-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(255, 215, 0, 0.2);
            border-color: var(--border-gold);
        }

        .evento-imagem {
            width: 100%;
            height: 200px;
            object-fit: cover;
            background: linear-gradient(135deg, #9C27B0, #7B1FA2);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 60px;
            color: rgba(255,255,255,0.3);
        }

        .evento-body {
            padding: 25px;
        }

        .evento-nome {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 15px;
            color: var(--color-gold);
        }

        .evento-info {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 10px;
            color: var(--text-secondary);
            font-size: 14px;
        }

        .evento-info i {
            width: 20px;
            color: var(--color-gold);
        }

        .evento-stats {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin: 20px 0;
            padding: 20px 0;
            border-top: 1px solid var(--border-color);
            border-bottom: 1px solid var(--border-color);
        }

        .stat-item {
            text-align: center;
        }

        .stat-value {
            font-size: 28px;
            font-weight: 700;
            color: var(--color-gold);
        }

        .stat-label {
            font-size: 11px;
            color: var(--text-secondary);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .btn {
            padding: 12px 20px;
            border: none;
            border-radius: 10px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            justify-content: center;
            width: 100%;
            margin-top: 10px;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--color-gold) 0%, var(--color-gold-dark) 100%);
            color: #000;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(255, 215, 0, 0.4);
        }

        .btn-secondary {
            background: var(--bg-secondary);
            color: var(--text-primary);
            border: 2px solid var(--border-color);
        }

        .btn-secondary:hover {
            border-color: var(--border-gold);
            background: var(--bg-card-hover);
        }

        .link-box {
            background: var(--bg-secondary);
            padding: 15px;
            border-radius: 10px;
            margin: 15px 0;
            border: 2px solid var(--border-color);
        }

        .link-label {
            font-size: 11px;
            color: var(--text-secondary);
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 8px;
        }

        .link-url {
            background: var(--bg-card);
            padding: 12px;
            border-radius: 8px;
            font-family: 'Courier New', monospace;
            font-size: 12px;
            word-break: break-all;
            color: var(--color-gold);
            margin-bottom: 10px;
            border: 1px solid var(--border-color);
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: var(--text-secondary);
        }

        .empty-state i {
            font-size: 80px;
            margin-bottom: 20px;
            opacity: 0.3;
        }

        @media (max-width: 768px) {
            .eventos-grid {
                grid-template-columns: 1fr;
            }

            .navbar-container {
                flex-direction: column;
                gap: 15px;
            }

            .navbar-links {
                flex-wrap: wrap;
                justify-content: center;
            }
        }
    </style>
</head>
<body>

    <?php include 'assets/sidebar.php'; ?>

    <div class="container">

        <div class="welcome-section">
            <h1 class="welcome-title">
                <i class="fas fa-calendar-alt"></i>
                Meus Eventos
            </h1>
            <p class="welcome-subtitle">
                Gerencie seus eventos associados como produtor
            </p>
        </div>

        <?php if (count($meus_eventos) > 0): ?>
            <h2 class="section-title">
                <i class="fas fa-calendar-check"></i>
                Meus Eventos Associados (<?= count($meus_eventos) ?>)
            </h2>

            <div class="eventos-grid">
                <?php foreach ($meus_eventos as $evento): ?>
                    <div class="evento-card">
                        <?php if ($evento['imagem']): ?>
                            <img src="uploads/eventos/<?= htmlspecialchars($evento['imagem']) ?>" class="evento-imagem" alt="Evento">
                        <?php else: ?>
                            <div class="evento-imagem">
                                <i class="fas fa-calendar-alt"></i>
                            </div>
                        <?php endif; ?>

                        <div class="evento-body">
                            <div class="evento-nome"><?= htmlspecialchars($evento['nome']) ?></div>

                            <div class="evento-info">
                                <i class="fas fa-calendar"></i>
                                <span><?= date('d/m/Y', strtotime($evento['data'])) ?></span>
                            </div>

                            <div class="evento-info">
                                <i class="fas fa-clock"></i>
                                <span><?= $evento['hora'] ?></span>
                            </div>

                            <?php if ($evento['total_arquivos'] > 0): ?>
                                <div class="evento-info">
                                    <i class="fas fa-file-download"></i>
                                    <span><?= $evento['total_arquivos'] ?> arquivo(s) disponível(is)</span>
                                </div>
                            <?php endif; ?>

                            <div class="evento-stats">
                                <div class="stat-item">
                                    <div class="stat-value"><?= $evento['meus_convidados'] ?></div>
                                    <div class="stat-label">Convidados</div>
                                </div>
                                <div class="stat-item">
                                    <div class="stat-value"><?= $evento['meus_checkins'] ?></div>
                                    <div class="stat-label">Check-ins</div>
                                </div>
                            </div>

                            <div class="link-box">
                                <div class="link-label"><i class="fas fa-link"></i> Seu Link Exclusivo</div>
                                <div class="link-url" id="link-<?= $evento['id'] ?>">
                                    <?= 'https://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/convite.php?link=' . $evento['link_exclusivo'] ?>
                                </div>
                                <button class="btn btn-primary" onclick="copiarLink(<?= $evento['id'] ?>, '<?= $evento['link_exclusivo'] ?>')">
                                    <i class="fas fa-copy"></i> Copiar Link
                                </button>
                            </div>

                            <?php if ($evento['total_arquivos'] > 0): ?>
                                <a href="evento_arquivos_view.php?evento_id=<?= $evento['id'] ?>" class="btn btn-secondary">
                                    <i class="fas fa-download"></i> Baixar Materiais
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="empty-state">
                <i class="fas fa-calendar-times"></i>
                <h2>Nenhum Evento Associado</h2>
                <p>Entre em contato com o administrador para ser associado a eventos.</p>
            </div>
        <?php endif; ?>

    </div>

    <script>
        function copiarLink(eventoId, linkToken) {
            const linkCompleto = 'https://' + window.location.host + window.location.pathname.replace('produtor_eventos.php', '') + 'convite.php?link=' + linkToken;

            navigator.clipboard.writeText(linkCompleto).then(() => {
                // Feedback visual
                const btn = event.target.closest('button');
                const originalHTML = btn.innerHTML;
                btn.innerHTML = '<i class="fas fa-check"></i> Link Copiado!';
                btn.style.background = '#00C851';

                setTimeout(() => {
                    btn.innerHTML = originalHTML;
                    btn.style.background = '';
                }, 2000);
            }).catch(err => {
                alert('Link: ' + linkCompleto);
            });
        }
    </script>

    </div><!-- /.main-content -->
    <script src="assets/js/sidebar.js"></script>
</body>
</html>
