<?php
// teste_debug_sistema.php - Debug do Sistema de Notificações e Check-ins
require_once 'config.php';

echo "<h1>Debug do Sistema</h1>";
echo "<style>
    body { font-family: Arial; background: #0a0a0a; color: #fff; padding: 20px; }
    table { border-collapse: collapse; width: 100%; margin: 20px 0; background: #1a1a1a; }
    th, td { border: 1px solid #FFD700; padding: 10px; text-align: left; }
    th { background: #2a2a2a; color: #FFD700; }
    h2 { color: #FFD700; border-bottom: 2px solid #FFD700; padding-bottom: 10px; }
    .success { color: #00C851; }
    .error { color: #dc3545; }
</style>";

// 1. VERIFICAR EVENTOS ATIVOS
echo "<h2>1. Eventos Ativos no Sistema</h2>";
$stmt = $pdo->query("SELECT id, nome, status, data FROM eventos ORDER BY created_at DESC LIMIT 10");
$eventos = $stmt->fetchAll();

echo "<table>";
echo "<tr><th>ID</th><th>Nome</th><th>Status</th><th>Data</th></tr>";
foreach ($eventos as $evento) {
    $color = $evento['status'] === 'ativo' ? 'style="background: rgba(0,200,81,0.2);"' : '';
    echo "<tr $color>";
    echo "<td>{$evento['id']}</td>";
    echo "<td>{$evento['nome']}</td>";
    echo "<td><strong>{$evento['status']}</strong></td>";
    echo "<td>{$evento['data']}</td>";
    echo "</tr>";
}
echo "</table>";

// 2. VERIFICAR CHECK-INS
echo "<h2>2. Check-ins por Evento</h2>";
$stmt = $pdo->query("
    SELECT
        e.id,
        e.nome,
        e.status,
        COUNT(c.id) as total_convidados,
        SUM(CASE WHEN c.checkin = 1 THEN 1 ELSE 0 END) as total_checkins
    FROM eventos e
    LEFT JOIN convidados c ON e.id = c.evento_id
    GROUP BY e.id
    ORDER BY e.created_at DESC
    LIMIT 10
");
$resultado = $stmt->fetchAll();

echo "<table>";
echo "<tr><th>Evento ID</th><th>Nome</th><th>Status</th><th>Total Convidados</th><th>Check-ins</th></tr>";
foreach ($resultado as $row) {
    $color = $row['status'] === 'ativo' ? 'style="background: rgba(0,200,81,0.2);"' : '';
    echo "<tr $color>";
    echo "<td>{$row['id']}</td>";
    echo "<td>{$row['nome']}</td>";
    echo "<td><strong>{$row['status']}</strong></td>";
    echo "<td>{$row['total_convidados']}</td>";
    echo "<td class='success'><strong>{$row['total_checkins']}</strong></td>";
    echo "</tr>";
}
echo "</table>";

// 3. QUERY ATUAL DO BADGE
echo "<h2>3. Query Atual do Badge (Eventos Ativos)</h2>";
$stmt = $pdo->query("
    SELECT COUNT(DISTINCT c.id) as total_checkins
    FROM convidados c
    INNER JOIN eventos e ON c.evento_id = e.id
    WHERE e.status = 'ativo' AND c.checkin = 1
");
$result = $stmt->fetch();
echo "<p class='success'>Total de check-ins em eventos ATIVOS: <strong style='font-size: 24px;'>{$result['total_checkins']}</strong></p>";

// 4. VERIFICAR ADMINS NO SISTEMA
echo "<h2>4. Admins no Sistema</h2>";
$stmt = $pdo->query("SELECT id, nome, email FROM users WHERE role = 'admin'");
$admins = $stmt->fetchAll();

echo "<table>";
echo "<tr><th>ID</th><th>Nome</th><th>Email</th></tr>";
foreach ($admins as $admin) {
    echo "<tr>";
    echo "<td>{$admin['id']}</td>";
    echo "<td>{$admin['nome']}</td>";
    echo "<td>{$admin['email']}</td>";
    echo "</tr>";
}
echo "</table>";

// 5. VERIFICAR NOTIFICAÇÕES DOS ADMINS
echo "<h2>5. Últimas Notificações dos Admins</h2>";
$stmt = $pdo->query("
    SELECT n.*, u.nome as usuario_nome
    FROM notificacoes n
    INNER JOIN users u ON n.user_id = u.id
    WHERE u.role = 'admin'
    ORDER BY n.created_at DESC
    LIMIT 20
");
$notifs = $stmt->fetchAll();

if (empty($notifs)) {
    echo "<p class='error'>⚠️ NENHUMA NOTIFICAÇÃO ENCONTRADA PARA ADMINS!</p>";
} else {
    echo "<table>";
    echo "<tr><th>ID</th><th>Admin</th><th>Tipo</th><th>Título</th><th>Mensagem</th><th>Lida</th><th>Criado em</th></tr>";
    foreach ($notifs as $notif) {
        $lida_class = $notif['lida'] ? '' : 'style="background: rgba(255,215,0,0.2);"';
        echo "<tr $lida_class>";
        echo "<td>{$notif['id']}</td>";
        echo "<td>{$notif['usuario_nome']}</td>";
        echo "<td>{$notif['tipo']}</td>";
        echo "<td><strong>{$notif['titulo']}</strong></td>";
        echo "<td>{$notif['mensagem']}</td>";
        echo "<td>" . ($notif['lida'] ? 'Sim' : '<strong>NÃO</strong>') . "</td>";
        echo "<td>{$notif['created_at']}</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// 6. TESTE DE CRIAÇÃO DE NOTIFICAÇÃO COM DETALHES
echo "<h2>6. Teste de Criação de Notificação (COM DETALHES)</h2>";

// Primeiro, verificar se a tabela existe
try {
    $stmt = $pdo->query("SHOW TABLES LIKE 'notificacoes'");
    $tabela_existe = $stmt->fetch();

    if (!$tabela_existe) {
        echo "<p class='error'>❌ PROBLEMA CRÍTICO: Tabela 'notificacoes' NÃO EXISTE no banco de dados!</p>";
        echo "<p>Você precisa criar a tabela. Quer que eu crie o SQL para você?</p>";
    } else {
        echo "<p class='success'>✅ Tabela 'notificacoes' existe</p>";

        // Verificar estrutura da tabela
        $stmt = $pdo->query("DESCRIBE notificacoes");
        $colunas = $stmt->fetchAll();

        echo "<h3>Estrutura da Tabela 'notificacoes':</h3>";
        echo "<table>";
        echo "<tr><th>Coluna</th><th>Tipo</th><th>Null</th><th>Default</th></tr>";
        foreach ($colunas as $col) {
            echo "<tr>";
            echo "<td>{$col['Field']}</td>";
            echo "<td>{$col['Type']}</td>";
            echo "<td>{$col['Null']}</td>";
            echo "<td>{$col['Default']}</td>";
            echo "</tr>";
        }
        echo "</table>";

        // Agora tentar criar notificação
        echo "<h3>Teste de Criação:</h3>";

        try {
            // Tentar criar notificação diretamente com SQL primeiro
            echo "<p>Testando INSERT direto no banco...</p>";
            $stmt = $pdo->prepare("
                INSERT INTO notificacoes (
                    user_id, tipo, categoria, titulo, mensagem,
                    referencia_tipo, referencia_id, link, icon, cor
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
            ");

            $result = $stmt->execute([
                1, // user_id
                'teste',
                'geral',
                'Teste Direto',
                'Este é um teste direto de INSERT',
                'sistema',
                null,
                'dashboard.php',
                'fa-bell',
                '#FFD700'
            ]);

            if ($result) {
                $notif_id = $pdo->lastInsertId();
                echo "<p class='success'>✅ INSERT direto funcionou! ID da notificação: $notif_id</p>";

                // Agora testar com a função
                echo "<p>Testando função criarNotificacao()...</p>";

                $result2 = criarNotificacao([
                    'user_id' => 1,
                    'tipo' => 'teste_funcao',
                    'categoria' => 'geral',
                    'titulo' => 'Teste via Função',
                    'mensagem' => 'Este é um teste via função criarNotificacao()',
                    'link' => 'dashboard.php'
                ]);

                if ($result2) {
                    echo "<p class='success'>✅ Função criarNotificacao() funcionou!</p>";
                } else {
                    echo "<p class='error'>❌ Função criarNotificacao() FALHOU!</p>";
                    echo "<p>Verifique se há mensagens de erro acima (logs PHP).</p>";
                }
            }

        } catch (PDOException $e) {
            echo "<p class='error'>❌ ERRO SQL: " . $e->getMessage() . "</p>";
            echo "<p>Código do erro: " . $e->getCode() . "</p>";

            // Se o erro for sobre coluna inexistente, mostrar qual
            if (strpos($e->getMessage(), "Unknown column") !== false) {
                echo "<p class='error'>A tabela existe mas está faltando uma coluna!</p>";
            }
        } catch (Exception $e) {
            echo "<p class='error'>❌ ERRO GERAL: " . $e->getMessage() . "</p>";
        }
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ ERRO ao verificar tabela: " . $e->getMessage() . "</p>";
}

// 7. VERIFICAR SE HÁ CAMPOS user_role NA TABELA NOTIFICACOES
echo "<h2>7. Verificação de Campo 'user_role'</h2>";
try {
    $stmt = $pdo->query("SHOW COLUMNS FROM notificacoes LIKE 'user_role'");
    $campo_role = $stmt->fetch();

    if ($campo_role) {
        echo "<p class='error'>⚠️ PROBLEMA: Tabela tem coluna 'user_role' que não deveria existir!</p>";
        echo "<p>A função criarNotificacao() usa 'user_id', não 'user_role'.</p>";
    } else {
        echo "<p class='success'>✅ Campo 'user_role' não existe (correto)</p>";
    }
} catch (Exception $e) {
    echo "<p class='error'>Erro: {$e->getMessage()}</p>";
}

echo "<hr>";
echo "<p><a href='dashboard.php' style='color: #FFD700;'>← Voltar ao Dashboard</a></p>";
echo "<p><a href='teste_debug_sistema.php' style='color: #FFD700;'>🔄 Recarregar Teste</a></p>";
?>
