<?php
/**
 * TESTE DE EMAIL VIA NAVEGADOR
 * Acesse este arquivo pelo navegador para diagnosticar o sistema de email
 * IMPORTANTE: DELETE este arquivo após o teste por segurança!
 */

require_once 'config.php';

// Processar envio de teste
$resultado = '';
if (isset($_POST['enviar_teste'])) {
    $email_destino = $_POST['email_destino'];

    if (filter_var($email_destino, FILTER_VALIDATE_EMAIL)) {
        $assunto = "🎉 Teste de Aniversário - " . date('d/m/Y H:i:s');
        $mensagem = "Parabéns!\n\nEste é um email de teste do sistema de aniversários.";

        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
        $headers .= "From: " . EMAIL_NOME_REMETENTE . " <" . EMAIL_REMETENTE . ">\r\n";

        $corpo_html = nl2br(htmlspecialchars($mensagem));
        $html_email = "
        <!DOCTYPE html>
        <html>
        <head>
            <meta charset='UTF-8'>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { background: linear-gradient(135deg, #FFD700 0%, #FFA500 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
                .content { background: #fff; padding: 30px; border: 1px solid #ddd; }
                .footer { background: #f5f5f5; padding: 20px; text-align: center; font-size: 12px; color: #666; border-radius: 0 0 10px 10px; }
                .emoji { font-size: 48px; }
            </style>
        </head>
        <body>
            <div class='container'>
                <div class='header'>
                    <div class='emoji'>🎉</div>
                    <h1 style='margin: 10px 0 0 0;'>{$assunto}</h1>
                </div>
                <div class='content'>
                    {$corpo_html}
                </div>
                <div class='footer'>
                    Enviado por " . EMAIL_NOME_REMETENTE . "
                </div>
            </div>
        </body>
        </html>";

        if (mail($email_destino, $assunto, $html_email, $headers)) {
            $resultado = '<div style="background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 20px 0;">
                ✅ Email enviado com sucesso para: ' . htmlspecialchars($email_destino) . '<br>
                Verifique sua caixa de entrada (e pasta de spam)
            </div>';
        } else {
            $resultado = '<div style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 20px 0;">
                ❌ Falha ao enviar email. Verifique os logs do servidor.
            </div>';
        }
    } else {
        $resultado = '<div style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 20px 0;">
            ❌ Email inválido!
        </div>';
    }
}

// Verificar status do sistema
$diagnostico = [];

// 1. Constantes
$diagnostico[] = [
    'titulo' => 'Constantes de Email',
    'items' => [
        'EMAIL_REMETENTE' => defined('EMAIL_REMETENTE') ? EMAIL_REMETENTE : '❌ NÃO DEFINIDA',
        'EMAIL_NOME_REMETENTE' => defined('EMAIL_NOME_REMETENTE') ? EMAIL_NOME_REMETENTE : '❌ NÃO DEFINIDA'
    ]
];

// 2. Banco de dados
try {
    $stmt = $pdo->query("SELECT email_remetente, email_nome_remetente FROM configuracoes WHERE id = 1");
    $config_email = $stmt->fetch();

    $diagnostico[] = [
        'titulo' => 'Configurações no Banco de Dados',
        'items' => [
            'Email Remetente' => $config_email['email_remetente'] ?? '❌ NÃO CONFIGURADO',
            'Nome Remetente' => $config_email['email_nome_remetente'] ?? '❌ NÃO CONFIGURADO'
        ]
    ];
} catch (PDOException $e) {
    $diagnostico[] = [
        'titulo' => 'Banco de Dados',
        'items' => [
            'Erro' => '❌ ' . $e->getMessage() . ' - EXECUTE A MIGRAÇÃO!'
        ]
    ];
}

// 3. Função mail()
$diagnostico[] = [
    'titulo' => 'Servidor PHP',
    'items' => [
        'Função mail()' => function_exists('mail') ? '✅ Disponível' : '❌ Não disponível'
    ]
];

// 4. Configurações de aniversário
try {
    $stmt = $pdo->query("SELECT * FROM configuracoes_aniversarios LIMIT 1");
    $config_aniv = $stmt->fetch();

    $diagnostico[] = [
        'titulo' => 'Configurações de Aniversários',
        'items' => [
            'Assunto Padrão' => substr($config_aniv['mensagem_padrao_assunto'], 0, 50),
            'Envio Automático' => $config_aniv['envio_automatico_ativo'] ? '✅ Ativo' : '⏸️ Inativo'
        ]
    ];
} catch (PDOException $e) {
    $diagnostico[] = [
        'titulo' => 'Configurações de Aniversários',
        'items' => ['Erro' => '❌ ' . $e->getMessage()]
    ];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teste de Email - Sistema de Aniversários</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: Arial, sans-serif;
            background: #0a0a0a;
            color: #fff;
            padding: 20px;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
        }
        h1 {
            color: #FFD700;
            margin-bottom: 30px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .warning {
            background: #dc3545;
            color: white;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-weight: bold;
        }
        .card {
            background: #1a1a1a;
            border-radius: 10px;
            padding: 25px;
            margin-bottom: 20px;
            border: 2px solid #2a2a2a;
        }
        .card h2 {
            color: #FFD700;
            margin-bottom: 15px;
            font-size: 20px;
        }
        .info-grid {
            display: grid;
            grid-template-columns: 200px 1fr;
            gap: 10px;
            margin-top: 15px;
        }
        .info-label {
            color: #999;
            font-weight: bold;
        }
        .info-value {
            color: #fff;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #FFD700;
            font-weight: bold;
        }
        input[type="email"] {
            width: 100%;
            padding: 12px;
            background: #0a0a0a;
            border: 2px solid #2a2a2a;
            border-radius: 8px;
            color: #fff;
            font-size: 16px;
        }
        input[type="email"]:focus {
            outline: none;
            border-color: #FFD700;
        }
        button {
            background: linear-gradient(135deg, #FFD700 0%, #FFA500 100%);
            color: #000;
            padding: 12px 30px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s;
        }
        button:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(255, 215, 0, 0.4);
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 Diagnóstico de Email - Sistema de Aniversários</h1>

        <div class="warning">
            ⚠️ ATENÇÃO: Este arquivo é apenas para testes. DELETE-o após concluir os testes por segurança!
        </div>

        <?= $resultado ?>

        <!-- Diagnóstico -->
        <?php foreach ($diagnostico as $secao): ?>
        <div class="card">
            <h2><?= htmlspecialchars($secao['titulo']) ?></h2>
            <div class="info-grid">
                <?php foreach ($secao['items'] as $label => $value): ?>
                <div class="info-label"><?= htmlspecialchars($label) ?>:</div>
                <div class="info-value"><?= htmlspecialchars($value) ?></div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endforeach; ?>

        <!-- Formulário de Teste -->
        <div class="card">
            <h2>📧 Enviar Email de Teste</h2>
            <form method="POST">
                <div class="form-group">
                    <label for="email_destino">Digite seu email para receber um teste:</label>
                    <input type="email" id="email_destino" name="email_destino"
                           placeholder="seu-email@exemplo.com" required>
                </div>
                <button type="submit" name="enviar_teste">🚀 Enviar Email de Teste</button>
            </form>
        </div>

        <div class="card">
            <h2>📝 Próximos Passos</h2>
            <div style="color: #999; line-height: 1.8;">
                <p><strong>Se você vê ❌ em algum item acima:</strong></p>
                <ol style="margin-left: 20px; margin-top: 10px;">
                    <li>Execute a migração: <code style="background: #0a0a0a; padding: 3px 8px; border-radius: 4px;">php executar_migracao_email.php</code></li>
                    <li>Configure o email em: Configurações → Configurações de Email</li>
                    <li>Recarregue esta página</li>
                </ol>
                <p style="margin-top: 15px;"><strong>Se tudo está ✅:</strong></p>
                <ol style="margin-left: 20px; margin-top: 10px;">
                    <li>Use o formulário acima para testar</li>
                    <li>Vá em Admin → Aniversários e envie uma mensagem manual</li>
                    <li><strong>DELETE este arquivo!</strong></li>
                </ol>
            </div>
        </div>
    </div>
</body>
</html>
