<?php
// ver_destinatarios.php - Ver para quem foram criadas as notificações
require_once 'config.php';
verificarLogin();

header('Content-Type: text/html; charset=utf-8');
echo "<h1>Verificar Destinatários - Debug</h1>";
echo "<hr>";

// Ver TODAS as mensagens
echo "<h2>1. Todas as Mensagens Criadas</h2>";
$stmt = $pdo->query("SELECT * FROM mensagens ORDER BY created_at DESC LIMIT 10");
$todas_mensagens = $stmt->fetchAll();
echo "<p><strong>Total:</strong> " . count($todas_mensagens) . "</p>";
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>ID</th><th>Remetente</th><th>Assunto</th><th>Destinatário Tipo</th><th>Criado em</th></tr>";
foreach ($todas_mensagens as $msg) {
    echo "<tr>";
    echo "<td>{$msg['id']}</td>";
    echo "<td>{$msg['remetente_nome']} (ID: {$msg['remetente_id']})</td>";
    echo "<td>{$msg['assunto']}</td>";
    echo "<td>{$msg['destinatario_tipo']}</td>";
    echo "<td>{$msg['created_at']}</td>";
    echo "</tr>";
}
echo "</table>";
echo "<hr>";

// Ver TODOS os destinatários
echo "<h2>2. Todos os Destinatários das Mensagens</h2>";
$stmt = $pdo->query("
    SELECT md.*, u.nome, u.role
    FROM mensagens_destinatarios md
    INNER JOIN users u ON md.destinatario_id = u.id
    ORDER BY md.created_at DESC
    LIMIT 20
");
$todos_dest = $stmt->fetchAll();
echo "<p><strong>Total:</strong> " . count($todos_dest) . "</p>";
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>ID</th><th>Mensagem ID</th><th>Destinatário</th><th>Role</th><th>Lida</th><th>Arquivada</th></tr>";
foreach ($todos_dest as $dest) {
    echo "<tr>";
    echo "<td>{$dest['id']}</td>";
    echo "<td>{$dest['mensagem_id']}</td>";
    echo "<td>{$dest['nome']} (ID: {$dest['destinatario_id']})</td>";
    echo "<td>{$dest['role']}</td>";
    echo "<td>" . ($dest['lida'] ? 'Sim' : 'Não') . "</td>";
    echo "<td>" . ($dest['arquivada'] ? 'Sim' : 'Não') . "</td>";
    echo "</tr>";
}
echo "</table>";
echo "<hr>";

// Ver TODAS as notificações
echo "<h2>3. Todas as Notificações Criadas</h2>";
$stmt = $pdo->query("
    SELECT n.*, u.nome, u.role
    FROM notificacoes n
    INNER JOIN users u ON n.user_id = u.id
    ORDER BY n.created_at DESC
    LIMIT 20
");
$todas_notif = $stmt->fetchAll();
echo "<p><strong>Total:</strong> " . count($todas_notif) . "</p>";
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>ID</th><th>Usuário</th><th>Role</th><th>Tipo</th><th>Categoria</th><th>Título</th><th>Lida</th><th>Criado em</th></tr>";
foreach ($todas_notif as $notif) {
    echo "<tr>";
    echo "<td>{$notif['id']}</td>";
    echo "<td>{$notif['nome']} (ID: {$notif['user_id']})</td>";
    echo "<td>{$notif['role']}</td>";
    echo "<td>{$notif['tipo']}</td>";
    echo "<td>{$notif['categoria']}</td>";
    echo "<td>{$notif['titulo']}</td>";
    echo "<td>" . ($notif['lida'] ? 'Sim' : 'Não') . "</td>";
    echo "<td>{$notif['created_at']}</td>";
    echo "</tr>";
}
echo "</table>";
echo "<hr>";

// Ver TODOS os usuários
echo "<h2>4. Todos os Usuários do Sistema</h2>";
$stmt = $pdo->query("
    SELECT id, nome, role, status, mensagens_nao_lidas, notificacoes_nao_lidas
    FROM users
    ORDER BY id
");
$todos_usuarios = $stmt->fetchAll();
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>ID</th><th>Nome</th><th>Role</th><th>Status</th><th>Msgs Não Lidas</th><th>Notifs Não Lidas</th></tr>";
foreach ($todos_usuarios as $u) {
    $highlight = ($u['id'] == $_SESSION['user_id']) ? "background: yellow;" : "";
    echo "<tr style='$highlight'>";
    echo "<td>{$u['id']}</td>";
    echo "<td>{$u['nome']}</td>";
    echo "<td>{$u['role']}</td>";
    echo "<td>{$u['status']}</td>";
    echo "<td>{$u['mensagens_nao_lidas']}</td>";
    echo "<td>{$u['notificacoes_nao_lidas']}</td>";
    echo "</tr>";
}
echo "</table>";

echo "<hr>";
echo "<p><strong>Legenda:</strong> Linha amarela = Você (logado atualmente)</p>";
echo "<p><a href='debug_notificacoes.php'>Debug Completo</a> | <a href='dashboard.php'>Dashboard</a></p>";
?>
